module Posten(
  Posten,
  artikel, 
  menge,
  posten,
  cent,
  hinzu) where

import Data.Maybe(fromJust)

import Artikel

-- Ein Posten ist ein Artikel zu einer bestimmten Menge.
-- Wir exportieren nur den Typ und die Selektoren, nicht den Konstruktor.
{-- Posten --}
data Posten = Posten Artikel Menge
              deriving (Eq, Show)
{-- end --}	      

{-- artikel --}	      
artikel :: Posten -> Artikel
artikel (Posten a _) = a
{-- end --}	      

{-- menge --}	      
menge :: Posten-> Menge
menge (Posten _ m) = n
{-- end --}	      

{-
-- Wir knnen die Selektoren nicht ableiten, sonst knnen wir damit Posten
-- verndern: 
data Posten = Posten { artikel :: Artikel
                     , menge   :: Menge 
                     }
                     deriving (Eq, Show)
-}

-- Konstruktor fr Posten
{-- posten --}
posten :: Artikel-> Menge-> Maybe Posten 
posten a m = 
  case preis a m of 
    Just _  -> Just (Posten a m)
    Nothing -> Nothing
{-- end --}    

-- Preis eines Posten
cent :: Posten-> Int
cent (Posten a m) = fromJust (preis a m)
               -- Hier wissen wir, dass der Preis definiert sein muss

hinzu :: Posten-> Posten-> Maybe Posten
hinzu (Posten a1 m1) (Posten a2 m2)
  | a1 == a2  = Just (Posten a1 (addiere m1 m2))
  | otherwise = Nothing 
