module Lager(
  Lager,
  leeresLager,
  einlagern,
  suche,
  liste,
  inventur
  ) where

import Data.Maybe(listToMaybe, fromJust)
import qualified Data.Map.Lazy as M

import Artikel
import Posten

-- Lagerhaltung:
data Lager = Lager (M.Map Artikel Menge)
             deriving Show

leeresLager :: Lager
leeresLager = Lager (M.empty)

einlagern :: Artikel-> Menge-> Lager-> Lager
einlagern a m (Lager l) = case posten a m of
   Just _  -> case M.lookup a l of
     Just q  -> Lager (M.insert a (addiere m q) l)
     Nothing -> Lager (M.insert a m l)
   Nothing -> Lager l

suche :: Artikel-> Lager-> Maybe Menge
suche a (Lager l) =  M.lookup a l

liste :: Lager-> [(Artikel, Menge)]
liste (Lager m) = M.toList m

inventur :: Lager-> Int
inventur = sum . map (fromJust . uncurry preis) . liste
