module Einkaufswagen(
  Einkaufswagen,
  leererWagen,
  einkauf,
  kasse,
  kassenbon
  ) where

import Artikel
import Posten hiding (artikel, menge)
import qualified Posten as P(artikel, menge) 

-- Der Einkaufswagen
{-- ekwg --}
data Einkaufswagen = Ekwg [Posten]
                     deriving (Eq, Show)
{-- end --}

leererWagen :: Einkaufswagen
leererWagen = Ekwg []

{-- einkauf --}
einkauf :: Artikel -> Menge -> Einkaufswagen
                            -> Einkaufswagen
einkauf a m (Ekwg ps) = case posten a m of
  Just p ->  Ekwg (p: ps)
  Nothing -> Ekwg ps
{-- end --}

kasse :: Einkaufswagen-> Int
kasse (Ekwg ps) = sum (map cent ps)

kassenbon :: Einkaufswagen-> String
kassenbon ew@(Ekwg ps) = 
  "Bob's Aulde Grocery Shoppe\n\n"++
  "Artikel              Menge      Preis\n"++
  "-------------------------------------\n"++
  concatMap artikel ps ++
  "=====================================\n"++
  "Summe:"++ formatR 31 (showEuro (kasse ew))
 
artikel :: Posten-> String
artikel p = 
   formatL 20 (show (P.artikel p)) ++
   formatR 7  (menge (P.menge p)) ++ 
   formatR 10 (showEuro (cent p)) ++ "\n"

menge :: Menge-> String
menge (Stueck n) = show n++ " St" 
menge (Gramm g)  = show g++ " g."
menge (Liter l)  = show l++ " l."

formatL :: Int-> String-> String
formatL n str = take n (str++ replicate n ' ')

formatR :: Int-> String-> String
formatR n str = 
  take n (replicate (n- length str) ' '++ str)

showEuro :: Int-> String
showEuro i = 
  show (div i 100) ++ "."++
  show (mod (div i 10) 10) ++
  show (mod i 10)++ " EU"
