module Artikel where

-- Modellierung der Artikel.
data Apfelsorte = Boskoop | CoxOrange | GrannySmith 
             deriving (Eq, Ord, Show)

apreis :: Apfelsorte -> Int
apreis Boskoop = 55
apreis CoxOrange = 60
apreis GrannySmith = 50

data Kaesesorte = Gouda | Appenzeller  
             deriving (Eq, Ord, Show)

kpreis :: Kaesesorte -> Double
kpreis Gouda = 1450
kpreis Appenzeller = 2270

data Bio = Bio | Konv
           deriving (Eq, Ord, Show)

data Artikel = 
   Apfel Apfelsorte  | Eier
 | Kaese Kaesesorte  | Schinken
 | Salami       | Milch Bio
 deriving (Eq, Ord, Show)

type Preis = Maybe Int

preis :: Artikel -> Menge-> Preis
preis (Apfel a) (Stueck n) = Just (n* apreis a)
preis Eier (Stueck n)    = Just (n* 20)
preis (Kaese k)(Gramm g) = Just (round(fromIntegral g* 1000* kpreis k))
preis Schinken (Gramm g) = Just (div (g* 199) 100)
preis Salami (Gramm g)   = Just (div (g* 159) 100)
preis (Milch bio) (Liter l) = 
   Just (round (l* case bio of Bio -> 119; Konv -> 69))
preis _ _ = Nothing

-- Mengen
data Menge = Stueck Int | Gramm  Int | Liter  Double
           deriving (Eq, Ord, Show)

-- Addition von Mengen
addiere :: Menge-> Menge-> Menge
addiere (Stueck i) (Stueck j)= Stueck (i+ j)
addiere (Gramm g) (Gramm h)  = Gramm (g+ h)
addiere (Liter l) (Liter m)  = Liter (l+ m)
addiere m n = error ("addiere: "++ show m++ " und "++ show n)
