module MapList(
  Map, empty, lookup, insert, delete, toList
  ) where

import Prelude hiding(lookup)
import Data.List(find,(\\))

data Map alpha beta = Map { toList :: [(alpha, beta)] }
                          deriving (Eq, Ord)

empty :: Map alpha beta
empty = Map []    

-- The predefined function lookup may not make use of the ordered list
lookup :: Ord alpha=> alpha-> Map alpha beta-> Maybe beta
lookup a (Map s) = fmap snd $ find ((a ==). fst) s
        
-- Insert at the right position
insert :: Ord alpha=> alpha-> beta-> Map alpha beta-> Map alpha beta
insert a v (Map s) = Map (insert' s) where
  insert' []         = [(a, v)]
  insert' s0@((b, w):s) | a >  b = (b, w): insert' s
                        | a == b = (a, v): s
                        | a <  b = (a, v): s0 

-- Delete -- we can stop as soon as we have found a match or a larger element
delete :: Ord alpha=> alpha-> Map alpha beta-> Map alpha beta
delete a (Map s) = Map (del s) where
  del [] = []
  del s0@((b, w): s) | a > b  = (b, w): del s
                     | a == b = s
                     | a < b  = s0

instance (Show alpha, Show beta)=> Show (Map alpha beta) where
  show (Map s) = show s

