module MapFun(
  Map, empty, lookup, insert, delete, toList)
where

import Prelude hiding(lookup)

data Map alpha beta = Map (alpha-> Maybe beta)

empty :: Map alpha beta
empty = Map (\x-> Nothing)

lookup :: Ord alpha=> alpha-> Map alpha beta-> Maybe beta
lookup a (Map s) = s a

insert :: Ord alpha=> alpha-> beta-> Map alpha beta-> Map alpha beta
insert a b (Map s) = Map (\x-> if x == a then Just b else s x)

delete :: Ord alpha=> alpha-> Map alpha beta-> Map alpha beta
delete a (Map s) = Map (\x-> if x == a then Nothing else s x)

-- Keine Instanz fr Eq und Show mglich

-- Auch keine Implementation fr toList mglich:
toList :: Ord alpha=> Map alpha beta-> [(alpha, beta)]
toList = error "No implementation for Map.toList"
