module Tree where

data Tree alpha = Mt | Node alpha (Tree alpha) (Tree alpha)

foldT :: beta-> (alpha-> beta-> beta-> beta)-> Tree alpha-> beta
foldT e f Mt = e
foldT e f (Node a l r) =  f a (foldT e f l) (foldT e f r)

instance Functor Tree where
  fmap f Mt = Mt
  fmap f (Node a l r)=  Node (f a) (fmap f l) (fmap f r)

-- Hhe mit foldT
{-- height --}
height :: Tree alpha-> Int
height = foldT 0 (\_ l r-> 1+ max l r)
{-- end --}

-- Inorder-Traversion mit foldT
{-- inorder --}
inorder :: Tree alpha-> [alpha]
inorder = foldT [] (\a l r-> l++ [a]++ r)
{-- end --}

-- Enthaltensein
{-- elem --}
isElem :: Eq alpha=> alpha-> Tree alpha-> Bool
isElem a = foldT False (\b l r-> a == b || l || r) 
{-- end --}


-- Test tree
t = Node 7 (Node 9 Mt Mt) (Node 5 (Node 16 Mt Mt) Mt)
