module TakeByFold where

import Prelude hiding (take)

take :: Int-> [alpha]-> [alpha]
take i = foldl (\p a-> if length p < i then (p++[a]) else p) []

takez :: Int-> [alpha]-> [alpha]
takez i = foldr (\(j, x) xs-> if j<= i then x:xs else xs) [] . zip [1..i]

-- Geht auch einfacher, wie in der Vorlesung besprochen.
takez' :: Int-> [alpha]-> [alpha]
takez' i = map snd . zip [1.. i]

-- Hier eine echte Implementation mit foldr
-- (terminiert natrlich nicht fr zyklische Listen)
taker :: Int-> [alpha]-> [alpha]
taker i xs =
   snd $ foldr (\a (cnt, as)-> (cnt+1, if cnt < 0 then [] else a:as))
               (i- length xs, []) xs
