module Queens where

type Pos = (Int, Int)

type Board = [Pos]

{-- queens --}
queens :: Int-> [Board]
queens n = qu n where
  qu :: Int-> [Board] 
  qu i | i == 0    = [[]] -- Nicht [] !
       | otherwise = [ p++ [(i, j)] | p <- qu (i-1), j <- [1.. n],
                                      safe p (i, j)]
{-- end --}


{-- safe --}
safe :: Board-> Pos-> Bool
safe others nu =  and [ not (threatens other nu) | other <- others ]
{-- end --}

{-- threatens --}
threatens :: Pos-> Pos-> Bool
threatens (i, j) (m, n) =  (j== n) || (i+j == m+n) || (i-j == m-n)
{-- end --}

-- A nicer output
render' :: Int-> Board-> String
render' n ps =
    "+" ++ replicate n '-' ++ "+\n" ++
    unlines ["|" ++ line ps i ++ "|" | i <- [1..n]] ++
    "+" ++ replicate n '-' ++ "+\n" where
      line ps y = [ if (x,y) `elem` ps then '*' else '.' | x <- [1..n]]

-- For a solution, we get its size by the maximum of the positions.
-- Does not work for any board.
render :: Board-> String
render [] = ""
render ps = render' (maximum (map fst ps ++ map snd ps)) ps


-- Number of solutions: map (length (queens i)) | i<- [0..]]
-- [1,1,0,0,2,10,4,40,92,352,724,2680,14200,73712,...
