module Primes where

-- Calculating primes with Eratosthenes

-- All primes
{-- primes --}
primes :: [Integer]
primes = sieve [2..] where
  sieve (p: ps) =  p: sieve (filter (\q-> q `mod` p /= 0) ps)
{-- end --}

-- Twin primes with list comprehension
{-- twin_primes --}
twin_primes :: [(Integer, Integer)]
twin_primes = [(x, y) | (x, y) <- zip primes (tail primes), x+2 == y]
{-- end --}
