module Fold where

import Prelude hiding (Bool, True, False, Maybe, Just, Nothing)


-- A strange datatype
{-- il --}
data IL = Cons Int IL | Err String | Mt
{-- end --}

{-- foldil --}
foldIL :: (Int-> beta-> beta)-> (String-> beta)-> beta-> IL-> beta
foldIL f e a (Cons i il) = f i (foldIL f e a il)
foldIL f e a (Err str)   = e str
foldIL f e a Mt          = a
{-- end --}

-- Booleans:
{-- bool --}
data Bool = False | True

foldBool :: beta-> beta-> Bool-> beta
foldBool a1 a2 False = a1
foldBool a1 a2 True  = a2
{-- end --}

-- Maybe (the option type)
{-- maybe --}
data Maybe alpha = Nothing | Just alpha

foldMaybe :: beta-> (alpha-> beta)-> Maybe alpha-> beta
foldMaybe b f Nothing  = b
foldMaybe b f (Just a) = f a 
{-- end --}

-- Pairs
{-- pairs --}
foldPair :: (alpha-> beta-> gamma)-> (alpha, beta)-> gamma
foldPair f (a, b)= f a b      
{-- end --}

{-- curry --}
curry :: ((alpha, beta)-> gamma)-> alpha-> beta-> gamma
curry f a b = f (a, b)
{-- end --}

-- Natural numbers:
{-- nat --}
data Nat = Zero | Succ Nat 

foldNat :: beta-> (beta-> beta)-> Nat-> beta
foldNat e f Zero  = e
foldNat e f (Succ n) = f (foldNat e f n)
{-- end --}

{-- natToInt --}
natToInt :: Nat-> Int
natToInt = foldNat 0 (1+)
{-- end --}

instance Show Nat where
  show = show . natToInt

intToNat :: Int-> Nat
intToNat x | x <= 0    = Zero
           | otherwise = Succ (intToNat (x-1))

-- Nats with type parameter: lists!
{-- fnat --}
data FNat alpha = FZero | FSucc alpha (FNat alpha)
{-- end --}

{-- foldfnat --}
foldFNat :: beta-> (alpha-> beta-> beta)-> FNat alpha-> beta
foldFNat e f FZero  = e
foldFNat e f (FSucc a n) = f a (foldFNat e f n)
{-- end --}

