#include <stdlib.h>
#include <stdio.h>

#include "list.h"

list cons(void *hd, list tl) 
{ list l;
  if ((l= (list)malloc(sizeof(struct list_t)))== NULL) {
    fprintf(stderr, "Out of memory\n");
    abort();
  }
  l-> elem= hd; l-> next= tl;
  return l;
}

int length(list l)
{
  int i;
 
  for (i= 0; l!= NULL; l= l-> next) i++;

  return i;
}


/* Map, rekursiv -- erzeugt eine neue Liste */
list map1(void *(*f)(void *x), list l)
{
  return l== NULL ?
         NULL : cons((*f)(l-> elem), map1(f, l-> next));
}    

/* Map, iterativ -- ersetzt in-place */
list map2(void *(*f)(void *x), list l)
{
  list c;
  for (c= l; c!= NULL; c= c-> next) {
    c-> elem= (*f)(c-> elem);  // Zugriff auf c->elem geht verloren
    } 
  return l;
}   

/* Map, iterative, mit free */
list map3(void *(*f)(void *x), list l)
{
  list c; void *d;  
  for (c= l; c!= NULL; c= c-> next) {
    d= c-> elem;
    c-> elem= (*f)(c-> elem);
    free(d); // Auch fragw�rdig-- was ist wenn f c->elem in-place �ndert?
    }
  return l;
}   


/* Map nur mit Seiteneffekten */
/* Funktion f ist f�r Freigabe verantwortlich. */
void map(void (*f)(void *x), list l)
{
  list c;
  for (c= l; c!= NULL; c= c-> next) {
    (*f)(c-> elem);
    }
}

/* Filter, rekursiv */
list filter(int (*f)(void *x), list l)
{
  list c;
  list prev;

  prev= NULL;
  for (c= l; c!= NULL; c= c-> next) {
    if (! (*f)(c-> elem)) {
      // Remove this entry
      if (prev == NULL) {
	      // we are removing the first entry
	      l= NULL;
        }
      else {
	      // We are removing somewhere in the middle
	      prev-> next= c-> next;
        free(c); // ???
      }
    } else {
      // Keep this entry
      prev= c;
      if (l == NULL) {
	      // We have found the first element to keep
	      l= c;
      }
    }
  }
  return l;
}
