#include <stdlib.h>
#include <stdio.h>
#include <math.h>

typedef struct {
  double x;
  double y;
  } point;

typedef struct {
  point midpoint;
  double radius;
  } circle_t;

circle_t *circle(point *m, double r) {
  circle_t *c; 
  
  if ((c= (circle_t *)malloc(sizeof(*c)))== NULL){
    fprintf(stderr, "Out of memory.");
    abort();
  }
  c-> midpoint= *m;
  c-> radius= r;
  return c;
}

double circle_area(circle_t *c) {
  return M_PI*c-> radius*c-> radius;
}

void circle_move(circle_t *c, point *p) {
  c->midpoint.x+= p-> x;
  c->midpoint.y+= p-> y;
}
  

typedef struct {
  point corner1;
  point corner2;
} rectangle_t;

rectangle_t *rectangle(point *c1, point *c2) {
  rectangle_t *r; 
  
  if ((r= (rectangle_t *)malloc(sizeof(*r)))== NULL) {
    fprintf(stderr, "Out of memory.");
    abort();
  }
  r-> corner1= *c1;
  r-> corner2= *c2;
  return r;
}

double rectangle_area(rectangle_t *r) {
  return abs(r->corner1.x- r->corner2.x)*
         abs(r->corner1.y- r->corner2.y);
}

void rectangle_move(rectangle_t *r, point *p) {
  r->corner1.x += p->x;
  r->corner1.y += p->y;
  r->corner2.x += p->x;
  r->corner2.y += p->y;
}
