import java.lang.System;

interface Function<S,T> { S apply(T a); }

class List<T> {
  public T elem;
  public List<T> next;

  public List(T el, List<T> tl) {
    this.elem= el;
    this.next= tl;
  }

  int length() {
    int i= 0;
    for (List<T> cur= this; cur != null; cur= cur.next)
      i++;
    return i;
  }

  void concat(List<T> o) 
  {
    List<T> cur= this; 
    while (cur.next != null) cur= cur.next;
    cur.next= o;    
  }

  // Problem: map aendert den Typen!
  void map(Function<T,T> f)
  {
    List<T> cur= this;

    while(cur.next != null)
	cur.elem= f.apply(cur.elem);
  }

  // Filter ist am besten statisch, weil es eventuell this entfernt
  static List<T> filter(List<T> l, Function<T,Boolean> f)
  {
      // Vgl. C implementation       
  }

public static void main(String[] args)
{
List<Integer> l= 
  new List<Integer>(new Integer(1), 
    new List<Integer>(new Integer(2), null));

List<Integer> l2 = 
  new List<Integer>(new Integer(4), 
    new List<Integer>(new Integer(5), null));

List<Character> l3 =
    new List<Character>(new Character('a'), null);

/* Does not work because int is an elementary type:
List<int> l4= new List<int>(1, null);
*/

l.concat(l2);  

/* 
l.concat(l3); // Does not work
*/

System.out.println("length: "+ l.length());
    
}
	    
}
