/* Functional Java */

import java.lang.Math.*;

class Point {
    double x;
    double y;

    Point(double x, double y) {
        this.x= x; 
        this.y= y;
    }
}

abstract class Figure {
    abstract double area();
    abstract Figure move(Point p);
    
    Figure moveHorizontal(double x) {
        return this.move(new Point(x, 0));
    }
}

class Circle extends Figure {

    Point midpoint;
    double radius;

    Circle(Point m, double r) {
        midpoint = m;
        radius= r;
    }

    double area() { 
        return (Math.PI*(radius* radius));
    }

    Circle move(Point p) {
        return new Circle(new Point(midpoint.x+ p.x, midpoint.y+ p.y), radius);
    }

}

class Rectangle extends Figure {

    Point corner1;
    Point corner2;

    Rectangle(Point p, Point q) {
        corner1 = p;
        corner2 = q;
    }

    double area() {
        return Math.abs(corner2.x- corner1.x)* Math.abs(corner2.y- corner1.y);
    }

    Rectangle move(Point p) {
        return new Rectangle( new Point(corner1.x+ p.x, corner1.y+ p.y)
                            , new Point(corner2.x+ p.x, corner2.y+ p.y));
    }

}