import java.lang.Math.*;

class Point {
    double x;
    double y;
}

abstract class Figure {

    abstract double area();
    abstract void move(Point p);

    Figure moveHorizontal(Double x) {
        this.move(new Point(x, 0));
    }

}

class Circle extends Figure {

    Point midpoint;
    double radius;

    Circle() {
        midpoint = new Point();
        midpoint.x= 0;
        midpoint.y= 0;
        radius= 1.0;
    }

    double area() { 
        return (Math.PI*(radius* radius));
    }

    void move(Point p) {
        midpoint.x += p.x;
        midpoint.y += p.y;
    }

}

class Rectangle extends Figure {

    Point corner1;
    Point corner2;

    Rectangle(Point p, Point q) {
        corner1 = p;
        corner2 = q;
    }

    double area() {
        return Math.abs(corner2.x- corner1.x)* Math.abs(corner2.y- corner1.y);
    }

    void move(Point p) {
        corner1.x+= p.x;
        corner1.y+= p.y;
        corner2.x+= p.x;
        corner2.y+= p.y;
    }

}