
type Point = (Double, Double)

data Figure = Circle { midpoint :: Point, radius :: Double }
            | Rectangle { corner1 :: Point, corner2 :: Point }

area :: Figure-> Double
area (Circle _ r) = pi*r^2
area (Rectangle (x1, y1) (x2, y2)) = abs (x2- x1)* abs (y2- y1) 

move :: Figure-> Point-> Figure
move (Circle (mx, my) r) (x, y) = Circle (mx+ x, my+ y) r
move (Rectangle (x1, y1) (x2, y2)) (x, y) = Rectangle (x1+ x, y1+ y) (x2+ x, y2+ y) 

moveHorizontal :: Figure-> Double-> Figure
moveHorizontal f x = move f (x, 0)