module Shoppe where

import Data.Maybe

-- Modellierung der Artikel.

data Apfelsort = Boskoop | CoxOrange | GrannySmith 
                 deriving (Eq, Show)

apreis :: Apfelsorte -> Int
apreis Boskoop = 55
apreis CoxOrange = 60
apreis GrannySmith = 50

data Kaesesorte = Gouda | Appenzeller  
             deriving (Eq, Show)

kpreis :: Kaesesorte -> Double
kpreis Gouda = 1450
kpreis Appenzeller = 2270

data Bio = Bio | Konv
           deriving (Eq, Show)

data Artikel = 
   Apfel Apfelsorte  | Eier
 | Kaese Kaesesorte  | Schinken
 | Salami       | Milch Bio
 deriving (Eq, Show)

data Menge = Stueck Int | Gramm  Int | Liter  Double
           deriving (Eq, Show)

type Preis = Maybe Int

preis :: Artikel -> Menge-> Preis
preis (Apfel a) (Stueck n) = Just (n* apreis a)
preis Eier (Stueck n)    = Just (n* 20)
preis (Kaese k)(Gramm g) = Just (round(fromIntegral g* 1000* kpreis k))
preis Schinken (Gramm g) = Just (div (g* 199) 100)
preis Salami (Gramm g)   = Just (div (g* 159) 100)
preis (Milch bio) (Liter l) = 
   Just (round (l* case bio of Bio -> 119; Konv -> 69))
preis _ _ = Nothing

cent :: Artikel-> Menge-> Int
cent a m = fromMaybe 0 (preis a m) -- gibt keinen Laufzeitfehler!


-- Addition von Mengen
addiere :: Menge-> Menge-> Menge
addiere (Stueck i) (Stueck j)= Stueck (i+ j)
addiere (Gramm g) (Gramm h)  = Gramm (g+ h)
addiere (Liter l) (Liter m)  = Liter (l+ m)
addiere m n = error ("addiere: "++ show m++ " und "++ show n)

-- Posten:
data Posten = Posten Artikel Menge
              deriving Show

-- Lagerhaltung:
type Lager = [Posten]

suche :: Artikel-> Lager-> Maybe Menge
suche art (Posten lart  m: l)
  | art == lart = Just m
  | otherwise   = suche art l
suche art []    = Nothing

einlagern :: Artikel-> Menge-> Lager-> Lager
einlagern a m l = 
  let hinein a m [] = [Posten a m]
      hinein a m (Posten al ml:l)
         | a == al   = Posten a (addiere m ml): l
         | otherwise = Posten al ml: hinein a m l
  in case preis a m of 
       Nothing -> l
       _ -> hinein a m l

type Einkaufskorb = [Posten]

einkauf :: Artikel-> Menge-> Einkaufskorb-> Einkaufskorb
einkauf a m e 
  | isJust (preis a m) = Posten a m: e
  | otherwise          = e

kasse :: Einkaufskorb-> Int
kasse [] = 0
kasse (Posten a m: e) = cent a m+ kasse e

kassenbon :: Einkaufskorb-> String
kassenbon ew = 

  "** Bob's Aulde-Time Grocery Shoppe **\n\n"++
  "Artikel              Menge      Preis\n"++
  "-------------------------------------\n"++
  artikel ew ++
  "=====================================\n"++
  "Summe:"++ formatR 31 (showEuro (kasse ew))
 
artikel :: Einkaufskorb-> String
artikel [] = ""
artikel (Posten a m: e) = 
   formatL 20 (show a) ++
   formatR 7  (menge m) ++ 
   formatR 10 (showEuro (cent a m)) ++ "\n"++ 
   artikel e

menge :: Menge-> String
menge (Stueck n) = show n++ " St" 
menge (Gramm g)  = show g++ " g."
menge (Liter l)  = show l++ " l."

formatL :: Int-> String-> String
formatL n str = take n (str++ replicate n ' ')

formatR :: Int-> String-> String
formatR n str = 
  take n (replicate (n- length str) ' '++ str)

showEuro :: Int-> String
showEuro i = 
  show (div i 100) ++ "."++
  show (mod (div i 10) 10) ++
  show (mod i 10)++ " EU"

inventur :: Lager-> Int
inventur [] = 0
inventur (Posten a m: l) = cent a m+ inventur l

{- Examples: -}

w1= einkauf (Apfel Boskoop) (Stueck 3) []
w2= einkauf Schinken (Gramm 50) w1
w3= einkauf (Milch Bio) (Liter 1) w2
w4= einkauf Schinken (Gramm 50) w3

l1= einlagern (Apfel Boskoop) (Stueck 1) []
l2= einlagern Schinken (Gramm 50) l1
l3= einlagern (Milch Bio) (Liter 6) l2
l4= einlagern (Apfel Boskoop) (Stueck 4) l3
l5= einlagern (Milch Bio) (Liter 4) l4
l6= einlagern Schinken (Gramm 50) l5
