module List where

-- Verstecken vordefinierter Bezeichner:
import Prelude hiding (head, tail, (++))
import Pair

-- "Unsere" Listen
{-- listen --}
data List alpha = Empty 
            | Cons alpha (List alpha)
{-- end --}
            deriving (Eq, Show)

-- Verkettung zweier Listen
{-- concat --}
(++) :: List alpha-> List alpha-> List alpha
Empty ++ t      = t
(Cons c s) ++ t = Cons c (s++ t)
{-- end --}

head :: List alpha-> alpha
head (Cons x _) = x

tail :: List alpha-> List alpha
tail (Cons _ xs) = xs

-- Example expressions:
ex2 =
{-- ex2 --}
 Cons 3 Empty ++ Cons 5 (Cons 57 Empty)
{-- end --}

ex1 = 
{-- ex1 --}
 Cons 'p' (Cons 'i' Empty) ++ Cons '3' Empty
{-- end --}

exA = right (Pair (3+4) Empty)
-- exB = head (Pair (Cons 'x' Empty) True)
exC = right (head (Cons (Pair 'x' 3) Empty))
exD = head (tail (Cons 3 (Cons 4 Empty)))
