" Vim plugin for appending a backslash in column 79 for a range of lines
" Last Change: 2002 Aug 20
" Maintainer: Gabriel Zachmann (www.gabrielzachmann.org)

" safeguard
if exists("loaded_appendbackslash")
  finish
endif
let loaded_appendbackslash = 1

"  append \ at col 79 to all lines (similar to emacs);
vmenu Plugin.Append\ \ \\			:silent call <SID>AppendBackslash()<CR>

" Append \ at col 79 to all lines (similar to emacs).
" Tabs are handled correctly.  \'s at the end of lines are re-adjusted.
" Over-long lines are left alone (almost ;-).
" Warning: in the following, there is one occurence of /<80 spaces>/.
" (If you know that expandtab is always set, you could remove the resp. parts.)
function s:AppendBackslash()
	let save_expandtab = &expandtab
	set expandtab
	'<,'>retab
	'<,'>s/\s*\\\s*$//e
	'<,'>s/^\(.\{,77\}\)$/\1                                                                                \\/e
	'<,'>s/^\(.\{,77\}\) *\\$/\1 \\/e
	'<,'>g!/\\$/s/$/\\/e
	let &expandtab = save_expandtab
	'<,'>retab
endfunction

