"
"  This is meant to be sourced from one of the *splchk files
"  It assumes $mywordlistl and $mywordlistg to be set!
"
" This file contains the following maps:
"  <F7> : add word under cursor into database (temporarily - ie. just this file)
"  <F8> : add word under cursor into user's local database permanently
"  <F11>: add word under cursor into user's global database (i.e., in his/her home dir.)
"  <F5> : goto next spelling error
"  <F6> : goto previous spelling error
"
" Please send bug fixes and suggestions to me (zach@igd.fhg.de)


" read user's additional words
if filereadable(expand($mywordlistl)) > 0
    so $mywordlistl
endif
if filereadable(expand($mywordlistg)) > 0
    so $mywordlistg
endif

nmap <F7>   :exe "syn keyword GoodWord " . expand("<cword>")<CR>
nmap <F8>   :exe "syn keyword GoodWord " . expand("<cword>")<CR>:!echo "syn keyword GoodWord <cword>" >> $mywordlistl<CR><CR>
nmap <F11>  :exe "syn keyword GoodWord " . expand("<cword>")<CR>:!echo "syn keyword GoodWord <cword>" >> $mywordlistg<CR><CR>
nmap <F5>   :call Spchknxt()<CR>
nmap <F6>   :call Spchkprv()<CR>

nmenu S&pelling.Add\ Word\ &temporarily<Tab>F7	:exe "syn keyword GoodWord " . expand("<cword>")<CR>
nmenu S&pelling.Add\ Word\ &locally<Tab>F8		:exe "syn keyword GoodWord " . expand("<cword>")<CR>:!echo "syn keyword GoodWord <cword>" >> $mywordlistl<CR>
nmenu S&pelling.Add\ Word\ &globally<Tab>F11	:exe "syn keyword GoodWord " . expand("<cword>")<CR>:!echo "syn keyword GoodWord <cword>" >> $mywordlistg<CR>
nmenu S&pelling.&Next\ error<Tab>F5				:call Spchknxt()<CR>
nmenu S&pelling.&Previous\ error<Tab>F6			:call Spchkprv()<CR>
nmenu S&pelling.Checking\ &Off					:syn clear GoodWord BadWord<CR>


function! Spchknxt()
  let s = &showcmd
  set noshowcmd

  let errid=synIDtrans(hlID("Error"))
  let lastline=line("$")
  
  " skip words until we find next error, must omit last line
  while line(".") < lastline
    norm w
    if synIDtrans(synID(line("."),col("."),1)) == errid
      break
    endif
  endwhile
  unlet errid
  unlet lastline

  let &showcmd = s
endfunction


function! Spchkprv()
  let s = &showcmd
  set noshowcmd

  let errid=synIDtrans(hlID("Error"))

  " skip words until we find next error, must omit first line
  while line(".") > 1
    norm b
    if synIDtrans(synID(line("."),col("."),1)) == errid
      break
    endif
  endwhile
  unlet errid

  let &showcmd = s
endfunction

