" Vim syntax file
" Language:	RCS log file (output of rlog)
" Maintainer:	Philippe Cade <phc@gmx.net>
" Last update:	1998 Aug 05 14:00:09
" RCS:		$Id: rlog.vim,v 1.1 1998/08/26 15:13:23 cade Exp $
" vim:ts=8:sw=8:noet:

" Remove any old syntax stuff hanging around
syntax clear

" titles
syntax match rlogTitle "^RCS file:"
syntax match rlogTitle "^Working file:"
syntax match rlogTitle "^head:"
syntax match rlogTitle "^branch:"
syntax match rlogTitle "^locks:"
syntax match rlogTitle "^access list:"
syntax match rlogTitle "^symbolic names:"
syntax match rlogTitle "^keyword substitution:"
syntax match rlogTitle "^total revisions:"
syntax match rlogTitle "selected revisions:"
syntax match rlogTitle "^description:"
syntax match rlogTitle "^date:"
syntax match rlogTitle "author:"
syntax match rlogTitle "locked by:"
syntax match rlogTitle "state:"
syntax match rlogTitle "lines:"

" revisions
syntax match rlogRevision "^revision "
syntax match rlogRevisionNumber "[0-9]\.[0-9\.]\+"

" date and time
syntax match rlogDate		"[0-9]\{4}/[0-9]\{2}/[0-9]\{2}"
syntax match rlogTime		"[0-9]\{2}:[0-9]\{2}:[0-9]\{2}"

" misc
syntax match rlogLine "^-*$"

" if !exists("did_rlog_syntax_inits")
  let did_rlog_syntax_inits = 1

  " The default methods for highlighting.  Can be overridden later
  highlight link rlogTitle		Title
  highlight link rlogRevision		Type
  highlight link rlogRevisionNumber	Number
  highlight link rlogDate		Number
  highlight link rlogTime		Number
  highlight link rlogLine		PreProc
" endif

let current_syntax = "rlog"
