" Set errorformat and makeprg for use with gcc
" Set shellpipe to grep away warnings from OpenSG header files

let current_compiler = "gcc"

" from ':h error-file-format', plus my modifications.
" (%-G = ignore)
" Parses error messages from the preprocessor.
" Skips some of the just informative messages.
" Skips all messages containing 'OSG' or '/usr/include' in the file name.
" If -Wno-system-headers is set with gcc,
" then the -G/usr/include should not be necessary (but, as of 3.0.4, it is).
set errorformat=%-G%\\C%[%^:]%#OSG%[%^:]%#:%.%#,
			   \%-G%\\s%#instantiated\ from\ here,
			   \%-G%.%#Each\ undeclared\ identifier\ is\ reported\ only%.%#,
			   \%-G/usr/include/%.%#,
			   \%f:%l:\ %tarning:\ %m,
			   \%f:%l:\ %m,
			   \%f:%l:%n:\ %m

"set makeprg=gmake\ -j

"set shellpipe=2>&1\|fgrep\ -v\ OpenSG\|tee

