" Vim filetype plugin file
" Language: LaTeX
" Maintainer:   Gabriel Zachmann (www.gabrielzachmann.org)
" Last Change:  2002 Aug 13



" Options
set wrapmargin=5 wrapscan cpoptions=BFst%
set include=\\\\\\(include\\\|input\\)
set formatoptions-=l
set formatoptions+=n21
set comments=:%


" parse LaTeX erros
compiler tex

" the following is needed so that * and ctrl-] work with my
" labelling convention (\label{xy:bla})
" and hdrtag (http://users.erols.com/astronaut/vim/)
set iskeyword+=:
set tags=./tags

" Mappings
nmap <buffer> [[ -<CR>?\\\(sub\)*\(chapter\\|section\\|paragraph\)?<CR>
nmap <buffer> ]] +<CR>/\\\(sub\)*\(chapter\\|section\\|paragraph\)/<CR>
inoremap <buffer> <C-A> 
inoremap <buffer> <C-O> 
inoremap <buffer> <C-U> 
inoremap <buffer> <C-Z> 
inoremap <buffer> <C-B> \begin{
inoremap <buffer> <C-F> Figure~\ref{fg:
inoremap <buffer> <C-T> \texttt{
inoremap <buffer> <C-N> \emph{
inoremap <buffer> <C-G> \textbf{
inoremap <buffer> <C-L> \textsl{
" context sensitive quotes
inoremap <buffer> "     <C-R>=<SID>TexQuotes()<CR>
" intelligent \end{} (doesn't handle nested begin/end pairs!)
inoremap <buffer> <C-E> <ESC>?\\begin{<CR>yf}``pnlcwend<ESC>o
" forward search (i.e., bring xdvi to same pos as vi)
nnoremap <buffer> ,g :emenu Latex.Jump\ to\ Xdvi<CR>
nmap <buffer> <C-LeftMouse> ,g

" mappings as advertised in the latex menu
nmap <buffer> <F5>	:emenu Latex.Make.Dvi<CR>
imap <buffer> <F5>	<ESC>:emenu Latex.Make.Dvi<CR>
nmap <buffer> <F6>	:emenu Latex.Make.Postscript<CR>
imap <buffer> <F6>	<ESC>:emenu Latex.Make.Postscript<CR>
nmap <buffer> <F7>	:emenu Latex.Make.PDF<CR>
imap <buffer> <F7>	<ESC>:emenu Latex.Make.PDF<CR>
nmap <buffer> <F8>	:emenu Latex.Make.Print<CR>
imap <buffer> <F8>	<ESC>:emenu Latex.Make.Print<CR>

" next error
nmap <buffer> <F4>	:cn<CR>

iab bi \begin{itemize}
iab ei 0\end{itemize}
iab bn \begin{enumerate}
iab een 0\end{enumerate}
" remember that ':' is a keyword char, too,
" so you must type <space><backsapce> to initiate abbreviation resolution ..
iab sf (see Figure~\ref{fg:
iab ss (see Section~\ref{sc:
iab sa (siehe Abschnitt~\ref{sc:

"  Abbreviations
runtime my/abbrev.vim

"  Correct common spelling errors automatically
runtime my/autocorrect.vim

" Spelling menu
runtime my/spellcheck.vim

"    PopUp menu
" The following opens xfig for the {word} under the cursor (plus adding
" the suffix .fig, and several command line options for xfig:
nmenu <silent> 1.1 PopUp.Edit\ Figure  :!cd Fig; export XENVIRONMENT=$HOME/app-defaults/Fig-color; xfig -geometry +30+50 -specialtext -rigidtext -metric -startfontsize 10 -startpsFont Palatino-Roman -zoom 2 <cfile>.fig&<CR><CR>

"
"    Latex menus
"
" When highlighted, lists of the form:
"  o bla
"  o blub
"    blub
" will be replaced by the corresponding itemize/enumerate list
" with the respective menu Latex->lists->itemize/enumerate.
" It works with "+" or "-" instead of "o", too.
"

nmenu &Latex.&Headings.&Chapter			O\chapter{HEAD}<Esc>bcw
vmenu &Latex.&Headings.&Chapter			<Esc>`>a}<Esc>`<i\chapter{<Esc>l
imenu &Latex.&Headings.&Chapter			\chapter{HEAD}<Esc>bcw

nmenu &Latex.&Headings.&Section			O\section{HEAD}<Esc>bcw
vmenu &Latex.&Headings.&Section			<Esc>`>a}<Esc>`<i\section{<Esc>l
imenu &Latex.&Headings.&Section			\section{HEAD}<Esc>bcw

nmenu &Latex.&Headings.S&ubsection		O\subsection{HEAD}<Esc>bcw
vmenu &Latex.&Headings.S&ubsection		<Esc>`>a}<Esc>`<i\subsection{<Esc>l
imenu &Latex.&Headings.S&ubsection		\subsection{HEAD}<Esc>bcw

nmenu &Latex.&Headings.Su&bsubsection	O\subsubsection{HEAD}<Esc>bcw
vmenu &Latex.&Headings.Su&bsubsection	<Esc>`>a}<Esc>`<i\subsubsection{<Esc>l
imenu &Latex.&Headings.Su&bsubsection	\subsubsection{HEAD}<Esc>bcw

nmenu &Latex.&Headings.&Paragraph		O\paragraph{HEAD}<Esc>bcw
vmenu &Latex.&Headings.&Paragraph		<Esc>`>a}<Esc>`<i\paragraph{<Esc>l
imenu &Latex.&Headings.&Paragraph		\paragraph{HEAD}<Esc>bcw

nmenu &Latex.&Headings.Subp&aragraph	O\subparagraph{HEAD}<Esc>bcw
vmenu &Latex.&Headings.Subp&aragraph	<Esc>`>a}<Esc>`<i\subparagraph{<Esc>l
imenu &Latex.&Headings.Subp&aragraph	\subparagraph{HEAD}<Esc>bcw

nmenu &Latex.&Environment.&Tabular		o%\begin{center}<CR>%\centering<CR>\begin{tabular}{@{}lr@{}}<CR>\toprule<CR>col1<Tab>& col2 \\<CR>\midrule<CR>\bottomrule<CR>\end{tabular}<CR>%\end{center}<CR><ESC>
imenu &Latex.&Environment.&Tabular		%\begin{center}<CR>%\centering<CR>\begin{tabular}{@{}lr@{}}<CR>\toprule<CR>col1<Tab>& col2 \\<CR>\midrule<CR>\bottomrule<CR>\end{tabular}<CR>%\end{center}<CR><ESC>
nmenu &Latex.&Environment.&Centered		o\begin{center}<CR>\end{center}<Esc>O
vmenu &Latex.&Environment.&Centered		<Esc>`>a<CR>\end{center}<Esc>`<i\begin{center}<CR><Esc>
imenu &Latex.&Environment.&Centered		\begin{center}<CR>\end{center}<Esc>O
nmenu &Latex.&Environment.&Quote		o\begin{quote}<CR>\end{quote}<Esc>O
vmenu &Latex.&Environment.&Quote		<Esc>`>a<CR>\end{quote}<Esc>`<i\begin{quote}<CR><Esc>
imenu &Latex.&Environment.&Quote		\begin{quote}<CR>\end{quote}<Esc>O
" remember that \label must come *after* \caption
nmenu &Latex.&Environment.&Figure		o\begin{figure}<CR>\caption{Bla}<CR>\label{fg:blub}<CR>\end{figure}<CR><Esc>
imenu &Latex.&Environment.&Figure		\begin{table}<CR>\caption{Bla}<CR>\label{fg:blub}<CR>\end{table}<CR>
nmenu &Latex.&Environment.&Table		o\begin{figure}<CR>\caption{Bla}<CR>\label{tb:blub}<CR>\end{figure}<CR><Esc>
imenu &Latex.&Environment.&Table		\begin{table}<CR>\caption{Bla}<CR>\label{tb:blub}<CR>\end{table}<CR>

nmenu &Latex.&Format.&Emphasis			i\emph{}<Esc>i
vmenu &Latex.&Format.&Emphasis			<Esc>`>a}<Esc>`<i\emph{<Esc>
imenu &Latex.&Format.&Emphasis			\emph{}<Esc>i

nmenu &Latex.&Format.&Typerwriter		i\texttt{}<Esc>i
vmenu &Latex.&Format.&Typerwriter		<Esc>`>a}<Esc>`<i\texttt{<Esc>
imenu &Latex.&Format.&Typerwriter		\texttt{}<Esc>i

nmenu &Latex.&Size.H&uge				i{\Huge }<Esc>i
vmenu &Latex.&Size.H&uge				<Esc>`>a}<Esc>`<i{\Huge <Esc>
imenu &Latex.&Size.H&uge				{\Huge }<Esc>i

nmenu &Latex.&Size.&huge				i{\huge }<Esc>i
vmenu &Latex.&Size.&huge				<Esc>`>a}<Esc>`<i{\huge <Esc>
imenu &Latex.&Size.&huge				{\huge }<Esc>i

nmenu &Latex.&Size.LA&RGE				i{\LARGE }<Esc>i
vmenu &Latex.&Size.LA&RGE				<Esc>`>a}<Esc>`<i{\LARGE <Esc>
imenu &Latex.&Size.LA&RGE				{\LARGE }<Esc>i

nmenu &Latex.&Size.L&arge				i{\Large }<Esc>i
vmenu &Latex.&Size.L&arge				<Esc>`>a}<Esc>`<i{\Large <Esc>
imenu &Latex.&Size.L&arge				{\Large }<Esc>i

nmenu &Latex.&Size.&large				i{\large }<Esc>i
vmenu &Latex.&Size.&large				<Esc>`>a}<Esc>`<i{\large <Esc>
imenu &Latex.&Size.&large				{\large }<Esc>i

nmenu &Latex.&Size.&normal				i{\normalsize }<Esc>i
vmenu &Latex.&Size.&normal				<Esc>`>a}<Esc>`<i{\normalsize <Esc>
imenu &Latex.&Size.&normal				{\normalsize }<Esc>i

nmenu &Latex.&Size.&small				i{\small }<Esc>i
vmenu &Latex.&Size.&small				<Esc>`>a}<Esc>`<i{\small <Esc>
imenu &Latex.&Size.&small				{\small }<Esc>i

nmenu &Latex.&Size.&footnote			i{\footnotesize }<Esc>i
vmenu &Latex.&Size.&footnote			<Esc>`>a}<Esc>`<i{\footnotesize <Esc>
imenu &Latex.&Size.&footnote			{\footnotesize }<Esc>i

nmenu &Latex.&Size.s&cript				i{\scriptsize }<Esc>i
vmenu &Latex.&Size.s&cript				<Esc>`>a}<Esc>`<i{\scriptsize <Esc>
imenu &Latex.&Size.s&cript				{\scriptsize }<Esc>i

nmenu &Latex.&Size.&tiny				i{\tiny }<Esc>i
vmenu &Latex.&Size.&tiny				<Esc>`>a}<Esc>`<i{\tiny <Esc>
imenu &Latex.&Size.&tiny				{\tiny }<Esc>i

nmenu &Latex.&List.&Itemized			o\begin{itemize}<CR><Tab>\item <CR><BS>\end{itemize}<Esc>kA
vmenu &Latex.&List.&Enumerated			:s/^[o+-]\s/\\item /<CR>`>o\end{itemize}<Esc>`<O\begin{itemize}<Esc>
imenu &Latex.&List.&Itemized			<CR>\begin{itemize}<CR><Tab>\item <CR><BS>\end{itemize}<Esc>kA

nmenu &Latex.&List.&Enumerated			o\begin{enumerate}<CR><Tab>\item <CR><BS>\end{enumerate}<Esc>kA
vmenu &Latex.&List.&Enumerated			:s/^[o+-]\s/\\item /<CR>`>o\end{enumerate}<Esc>`<O\begin{enumerate}<Esc>
imenu &Latex.&List.&Enumerated			<CR>\begin{enumerate}<CR><Tab>\item <CR><BS>\end{enumerate}<Esc>kA

nmenu &Latex.&Reference.Section&Label	i~\label{sc:sec}<Esc>bcw
vmenu &Latex.&Reference.Section&Label	<Esc>`>a}<Esc>`<i\label{sc:<Esc>
imenu &Latex.&Reference.Section&Label	\label{sc:sec}<Esc>bcw

nmenu &Latex.&Reference.ReferTo&Section	i(see Section~\ref{sc:sec})<Esc>4hcw
vmenu &Latex.&Reference.ReferTo&Section	<Esc>`>a})<Esc>`<i(see Section~\ref{sc:<Esc>
imenu &Latex.&Reference.ReferTo&Section	(see Section~\ref{sc:sec})<Esc>4hcw

nmenu &Latex.&Reference.ReferTo&Figure	i(see Figure~\ref{fg:sec})<Esc>4hcw
vmenu &Latex.&Reference.ReferTo&Figure	<Esc>`>a})<Esc>`<i(see Figure~\ref{fg:<Esc>
imenu &Latex.&Reference.ReferTo&Figure	(see Figure~\ref{fg:sec})<Esc>4hcw

nmenu &Latex.&Reference.&Cite			i~\cite{}<Esc>hi
vmenu &Latex.&Reference.&Cite			<Esc>`>a}<Esc>`<i~\cite{<Esc>
imenu &Latex.&Reference.&Cite			~\cite{}<Esc>hi

nmenu &Latex.&Make.&Dvi<Tab>F5			:set makeprg=ltx\ -x\ %:r<CR>:make<CR><CR>
nmenu &Latex.&Make.&Postscript<Tab>F6	:set makeprg=ltx\ -x\ -p\ %:r<CR>:make<CR><CR>
nmenu &Latex.&Make.&PDF<Tab>F7			:set makeprg=ltx\ -x\ -D\ -P\ %:r<CR>:make<CR><CR>
nmenu &Latex.&Make.-SEP1-				<Nop>
nmenu &Latex.&Make.&Clean\ Dvi			:set makeprg=ltx\ -C\ -x\ -D\ %:r<CR>:make<CR><CR>
nmenu &Latex.&Make.Clean\ Postscript	:set makeprg=ltx\ -C\ -x\ -p\ %:r<CR>:make<CR><CR>
nmenu &Latex.&Make.Clean\ PDF			:set makeprg=ltx\ -C\ -x\ -D\ -P\ %:r<CR>:make<CR><CR>
nmenu &Latex.&Make.-SEP2-				<Nop>
nmenu &Latex.&Make.&LaTeX				:set makeprg=ltx\ -x\ -L\ %:r<CR>:make<CR><CR>
nmenu &Latex.&Make.LaTeX\ +\ dvips		:set makeprg=ltx\ -x\ -L\ -p\ %:r<CR>:make<CR><CR>
nmenu &Latex.&Make.LaTeX\ +\ dvipdfm	:set makeprg=ltx\ -x\ -L\ -D\ -f\ \\\\def\\\\online{1}\ -P\ %:r<CR>:make<CR><CR>
nmenu &Latex.&Make.-SEP3-				<Nop>
nmenu &Latex.&Make.Images\ PS\ lores	:!cd Snapshots; make clean; make lores<CR><CR>
nmenu &Latex.&Make.Images\ PS\ hires	:!cd Snapshots; make clean; make hires<CR><CR>
nmenu &Latex.&Make.Images\ PDF\ lores	:!cd Snapshots; make clean; make lores; rm -f ../Img_lores/*.eps<CR><CR>
nmenu &Latex.&Make.Images\ PDF\ hires	:!cd Snapshots; make clean; make hires; rm -f ../Img_hires/*.eps<CR><CR>
nmenu &Latex.&Make.-SEP4-				<Nop>
nmenu &Latex.&Make.&Bibtex				:!btx %:r<CR><CR>
nmenu &Latex.&Make.Show\ &Log			:split %:r.log<CR>
nmenu &Latex.&Jump\ to\ Xdvi			:execute "!xdvi -sourceposition ".line(".").':'.col(".").expand("%")." ".expand("%:r").".dvi"<CR><CR>

" Quick links to frequently used documentation;
" works probably only if you have a tetex distro, otherwise modify;
" the ':h latex' works only if you have the latexhelp.txt file installed.

nmenu &Latex.&Doc.General			:help latex<CR>
nmenu &Latex.&Doc.-Sep1-			:
nmenu &Latex.&Doc.AMS\ Math			:!xdvi -paper a4 -nopostscript -keep -s 7 -gsalpha -bg white /usr/share/texmf/doc/latex/amsmath/amsldoc.dvi&<CR><CR>
nmenu &Latex.&Doc.theorem			:!xdvi -paper a4 -nopostscript -keep -s 7 -gsalpha -bg white /usr/share/texmf/doc/latex/tools/theorem.dvi&<CR><CR>
nmenu &Latex.&Doc.Math\ symbols		:!xdvi -paper a4 -nopostscript -keep -s 7 -gsalpha -bg white /usr/share/texmf/doc/latex/general/symbols.dvi&<CR><CR>
nmenu &Latex.&Doc.-Sep2-			:
nmenu &Latex.&Doc.Complete\ symbols	:!acroread /raphael/knowledge/tex/symbols-complete.pdf &<CR><CR>
nmenu &Latex.&Doc.Script\ fonts		:!acroread /raphael/knowledge/tex/scriptfonts.pdf &<CR><CR>
nmenu &Latex.&Doc.Text\ symbols		:!xdvi -paper a4 -nopostscript -keep -s 7 -gsalpha -bg white /raphael/knowledge/tex/textcomptst.dvi&<CR><CR>
nmenu &Latex.&Doc.-Sep3-			:
nmenu &Latex.&Doc.geometry			:!xdvi -paper a4 -nopostscript -keep -s 7 -gsalpha -bg white /usr/share/texmf/doc/latex/geometry/geometry.dvi&<CR><CR>
nmenu &Latex.&Doc.titlesec			:!xdvi -paper a4 -nopostscript -keep -s 7 -gsalpha -bg white /usr/share/texmf/doc/latex/styles/titlesec.dvi&<CR><CR>
nmenu &Latex.&Doc.algorithms		:!xdvi -paper a4 -nopostscript -keep -s 7 -gsalpha -bg white /usr/share/texmf/doc/latex/styles/algorithms.dvi&<CR><CR>
nmenu &Latex.&Doc.-Sep4-			:
nmenu &Latex.&Doc.mdwlist			:!xdvi -paper a4 -nopostscript -keep -s 7 -gsalpha -bg white /usr/share/texmf/doc/latex/mdwtools/mdwlist.dvi&<CR><CR>
nmenu &Latex.&Doc.mdwtab			:!xdvi -paper a4 -nopostscript -keep -s 7 -gsalpha -bg white /usr/share/texmf/doc/latex/mdwtools/mdwtab.dvi&<CR><CR>
nmenu &Latex.&Doc.tabular/array		:!xdvi -paper a4 -nopostscript -keep -s 7 -gsalpha -bg white /usr/share/texmf/doc/latex/tools/array.dvi&<CR><CR>
nmenu &Latex.&Doc.tabularx			:!xdvi -paper a4 -nopostscript -keep -s 7 -gsalpha -bg white /usr/share/texmf/doc/latex/tools/tabularx.dvi&<CR><CR>
nmenu &Latex.&Doc.booktabs			:!xdvi -paper a4 -nopostscript -keep -s 7 -gsalpha -bg white /usr/share/texmf/doc/latex/booktabs/booktabs.dvi&<CR><CR>
nmenu &Latex.&Doc.-Sep5-			:
nmenu &Latex.&Doc.Graphics			:!gv -safer -pixmap /usr/share/texmf/doc/latex/graphics/epslatex.ps&<CR><CR>
nmenu &Latex.&Doc.graphicx			:!gv -safer -pixmap /usr/share/texmf/doc/latex/graphics/grfguide.ps&<CR><CR>
nmenu &Latex.&Doc.-Sep6-			:
nmenu &Latex.&Doc.babel				:!xdvi -paper a4 -nopostscript -keep -s 7 -gsalpha -bg white /usr/share/texmf/doc/generic/babel/user.dvi&<CR><CR>
nmenu &Latex.&Doc.Brief				:!xdvi -paper a4 -nopostscript -keep -s 7 -gsalpha -bg white $HOME/texmf/tex/latex/g-brief/g-brief.dvi&<CR><CR>



"
"   Return `` or '' depending on context
"

if !exists("*s:TexQuotes")
function s:TexQuotes()
	let insert = "''"
	let left = strpart(getline("."), col(".")-2, 1)

	if (left == '' || left !~ '[a-zA-Z0-9\.,;:)\]}]')
		let insert = '``'
	endif

	return insert
endfunction
endif

