" Vim filetype plugin file
" Language: Mail
" Maintainer:   Gabriel Zachmann (www.gabrielzachmann.org)
" Last Change:  2002 Aug 13


setl comments=nb:\",nb:>,nb:},nb:]
setl noai equalprg=par textwidth=75 wrapscan expandtab

runtime autocorrect.vim

" insert official 'signature'
nmap <buffer> <F4> G?^-- $?<CR>-:r ~/Mail/trailer<CR>
nmenu Misc.Include\ FhG\ Trailer<Tab>F4      :$<CR>:?-- ?<CR>:-<CR>:r ~/letters/fhg.trailer<CR>

" common abbreviations
iab mfg Mit freundlichen Gruessen
iab br  Best regards
iab sc  Sincerely
iab sg	Sehr geehrter
iab gz  Gabriel Zachmann

" remove quoted sig's, if any (in particular, the one from the sender)
"g/^[>" ]\+-- $/.;/^[>" ]\+$/-d

"$			" end of file
"put='>-- '	" put dummy sig delimiter, so the // below will always find sth.
"1			" go back to beginning of text
"/^[>"]\s*[-_=]\{2} *$/		" find end of quoted material
"if line('.') < line('$')	" it's not our dummy sig del.
	"" kill quoted sig (exe needed b/c of a bug in vim)
	"exe ';/^$/-1d'
"endif
"$d							" remove dummy sig again

" placing the cursor after the headers is done by
" 1. for slrn: set editor = "vim +%d %s"
" 2. for mutt: set editor = "vim -c '/^$/+1' %s"

if expand("%:t") == ".article" ||
\	   ( expand("%:t") =~ 'mutt-\w\+-\d\+-\d\+' &&
\		 getline(7) !~ '^In-Reply-To:' && getline(9) !~ 'Forwarded message' )
	" new post/mail, so we probably want to start writing right away
	startinsert
endif

" Spelling menu
runtime my/spellcheck.vim

