" Vim filetype plugin file
" Language: HTML
" Maintainer:   Gabriel Zachmann (www.gabrielzachmann.org)
" Last Change:  2002 Aug 13
" similar stuff at ftp://tritarget.com/pub/vim/scripts/xmledit.vim


" safeguards
if exists("b:did_ftplugin")
  finish
endif
let b:did_ftplugin = 1
let s:save_cpo = &cpo
set cpo&vim



augroup html
	au!

	"   Insert the current date and time in a *.html file when writing it
	autocmd BufWritePre,FileWritePre *.html  call <SID>LastModified()

augroup end


"   Options
set wrapmargin=5 wrapscan
set matchpairs+=<:>

"   Mappings
nmap <buffer> [[ ?^\s*<\([hH][1-6]\\|[bB][oO][dD][yY]\\|[uU][lL]\\|[dD][lL]\)?<CR>
nmap <buffer> ]] /^\s*<\([hH][1-6]\\|[bB][oO][dD][yY]\\|[uU][lL]\\|[dD][lL]\)/<CR>
inoremap <buffer> <C-A> &auml;
inoremap <buffer> <C-O> &ouml;
inoremap <buffer> <C-U> &uuml;
inoremap <buffer> <C-Z> &szlig;
inoremap <buffer> <C-T> <TT>
inoremap <buffer> <C-J> <I>
inoremap <buffer> <C-E> <EM>
inoremap <buffer> <C-N> <BR>
inoremap <buffer> <C-B> <P>

inoremap <buffer> '' &quot;
inoremap <buffer> & &amp;
inoremap <buffer> <C-L> &lt;
inoremap <buffer> <C-G> &gt;

"   Put html comments around line
nmap <buffer> <F7> I<!--<ESC>A--><ESC>+

"   Delete html comment (doesn't check, if any)
nmap <buffer> <F8> ^4x$xxx+

"   Insert closing tag matching the most recent open tag
inoremap <buffer> <F5> <ESC>:call <SID>InsertCloseTag()<CR>a
nnoremap <buffer> <F5> :call <SID>InsertCloseTag()<CR>

"   Abbreviations: "da", "mu"
inoreab ds da&szlig;
inoreab ms mu&szlig;
inoreab fr f&uuml;r

"   Spelling menu
runtime my/spellcheck.vim

"   HTML Menu
"
" from http://www.mauigateway.com/~urban/projects/vim/syn-menus;
" can't use 'amenu' here, because I redefined ctrl-o to &ouml;

nmenu &HTML.&Comment				<Space>bi<!--<Esc>ea--><Esc>
vmenu &HTML.&Comment				<Esc>`>a --><Esc>`<i<!-- <Esc>
imenu &HTML.&Comment				<!-- COMMENT --><Esc>2bcw

nmenu &HTML.&Name\ Anchor			<Space>bi<A NAME="<Esc>ea"></A><Esc>
vmenu &HTML.&Name\ Anchor			c<A NAME=""><C-R>"</A><Esc>?NAME=<C-M>f"a
imenu &HTML.&Name\ Anchor			<A NAME="NAME"></A><Esc>3bcw

nmenu &HTML.&Href\ Anchor			<Space>bi<A HREF=""><Esc>ea</A><Esc>F"i
vmenu &HTML.&Href\ Anchor			<Esc>`>a</A><Esc>`<i<A HREF="URL"><Esc>2bcw
imenu &HTML.&Href\ Anchor			<A HREF="URL">TAG</A><Esc>5bcw

nmenu &HTML.&Image					<Space>bi<IMG SRC="URL" ALT="<Esc>ea"><Esc>?URL?<CR>cw
vmenu &HTML.&Image					<Esc>`>a" ALT="IMAGE"><Esc>`<i<IMG SRC="><Esc>l
imenu &HTML.&Image					<IMG SRC="URL" ALT="IMAGE"><Esc>6bcw

nmenu &HTML.&Headings.H&1			I<H1><Esc>A</H1><Esc>
vmenu &HTML.&Headings.H&1			<Esc>`>a</H1><Esc>`<i<H1><Esc>l
imenu &HTML.&Headings.H&1			<H1>HEADING</H1><Esc>3bcw

nmenu &HTML.&Headings.H&2			I<H2><Esc>A</H2><Esc>
vmenu &HTML.&Headings.H&2			<Esc>`>a</H2><Esc>`<i<H2><Esc>l
imenu &HTML.&Headings.H&2			<H2>HEADING</H2><Esc>3bcw

nmenu &HTML.&Headings.H&3			I<H3><Esc>A</H
vmenu &HTML.&Headings.H&3			<Esc>`>a</H3><Esc>`<i<H3><Esc>l
imenu &HTML.&Headings.H&3			<H3>HEADING</H3><Esc>3bcw

nmenu &HTML.&Headings.H&4			I<H4><Esc>A</H4><Esc>
vmenu &HTML.&Headings.H&4			<Esc>`>a</H4><Esc>`<i<H4><Esc>l
imenu &HTML.&Headings.H&4			<H4>HEADING</H4><Esc>3bcw

nmenu &HTML.&Headings.H&5			I<H5><Esc>A</H5><Esc>
vmenu &HTML.&Headings.H&5			<Esc>`>a</H5><Esc>`<i<H5><Esc>l
imenu &HTML.&Headings.H&5			<H5>HEADING</H5><Esc>3bcw

nmenu &HTML.&Headings.H&6			I<H6><Esc>A</H6><Esc>
vmenu &HTML.&Headings.H&6			<Esc>`>a</H6><Esc>`<i<H6><Esc>l
imenu &HTML.&Headings.H&6			<H6>HEADING</H6><Esc>3bcw

nmenu &HTML.&Formats.&Address		I<ADDRESS><Esc>A</ADDRESS><Esc>
vmenu &HTML.&Formats.&Address		<Esc>`>a</ADDRESS><Esc>`<i<ADDRESS><Esc>l
imenu &HTML.&Formats.&Address		<ADDRESS>TEXT</ADDRESS><Esc>3bcw

nmenu &HTML.&Formats.&Bigger		I<BIG><Esc>ea</BIG><Esc>
vmenu &HTML.&Formats.&Bigger		<Esc>`>a</BIG><Esc>`<i<BIG><Esc>l
imenu &HTML.&Formats.&Bigger		<BIG>TEXT</BIG><Esc>3bcw

nmenu &HTML.&Formats.Block&quote	<Space>{o<BLOCKQUOTE><Esc>}O</BLOCKQUOTE><Esc>
vmenu &HTML.&Formats.Block&quote	<Esc>`>a</BLOCKQUOTE><Esc>`<i<BLOCKQUOTE><Esc>l
imenu &HTML.&Formats.Block&quote	<BLOCKQUOTE>TEXT</BLOCKQUOTE><Esc>3bcw

nmenu &HTML.&Formats.&Bold			<Space>bi<B><Esc>ea</B><Esc>
vmenu &HTML.&Formats.&Bold			<Esc>`>a</B><Esc>`<i<B><Esc>l
imenu &HTML.&Formats.&Bold			<B>TEXT</B><Esc>3bcw

nmenu &HTML.&Formats.&Center		I<CENTER><Esc>A</CENTER><Esc>
vmenu &HTML.&Formats.&Center		<Esc>`>o</CENTER><Esc>`<O<CENTER><Esc>l
imenu &HTML.&Formats.&Center		<CENTER>TEXT</CENTER><Esc>3bcw

nmenu &HTML.&Formats.Code			<Space>bi<CODE><Esc>ea</CODE><Esc>
vmenu &HTML.&Formats.Code			<Esc>`>a</CODE><Esc>`<i<CODE><Esc>l
imenu &HTML.&Formats.Code			<CODE>TEXT</CODE><Esc>3bcw

nmenu &HTML.&Formats.&Emphasis		<Space>bi<EM><Esc>ea</EM><Esc>
vmenu &HTML.&Formats.&Emphasis		<Esc>`>a</EM><Esc>`<i<EM><Esc>l
imenu &HTML.&Formats.&Emphasis		<EM>TEXT</EM><Esc>3bcw

nmenu &HTML.&Formats.&Italics		<Space>bi<I><Esc>ea</I><Esc>
vmenu &HTML.&Formats.&Italics		<Esc>`>a</I><Esc>`<i<I><Esc>l
imenu &HTML.&Formats.&Italics		<I>TEXT</I><Esc>3bcw

nmenu &HTML.&Formats.&No\ Break		I<NOBR><Esc>A</NOBR><Esc>
vmenu &HTML.&Formats.&No\ Break		<Esc>`>a</NOBR><Esc>`<i<NOBR><Esc>l
imenu &HTML.&Formats.&No\ Break		<NOBR>TEXT</NOBR><Esc>3bcw

nmenu &HTML.&Formats.&Preformat		I<PRE><Esc>A</PRE><Esc>
vmenu &HTML.&Formats.&Preformat		<Esc>`>a</PRE><Esc>`<i<PRE><Esc>l
imenu &HTML.&Formats.&Preformat		<PRE>TEXT</PRE><Esc>3bcw

nmenu &HTML.&Formats.&Smaller		<Space>bi<SMALL><Esc>ea</SMALL><Esc>
vmenu &HTML.&Formats.&Smaller		<Esc>`>a</SMALL><Esc>`<i<SMALL><Esc>l
imenu &HTML.&Formats.&Smaller		<SMALL>TEXT</SMALL><Esc>3bcw

nmenu &HTML.&Formats.Su&bscript		<Space>bi<SUB><Esc>ea</SUB><Esc>
vmenu &HTML.&Formats.Su&bscript		<Esc>`>a</SUB><Esc>`<i<SUB><Esc>l
imenu &HTML.&Formats.Su&bscript		<SUB>TEXT</SUB><Esc>3bcw

nmenu &HTML.&Formats.Su&perscript	<Space>bi<SUP><Esc>ea</SUP><Esc>
vmenu &HTML.&Formats.Su&perscript	<Esc>`>a</SUP><Esc>`<i<SUP><Esc>l
imenu &HTML.&Formats.Su&perscript	<SUP>TEXT</SUP><Esc>3bcw

nmenu &HTML.&Formats.&Typerwriter	<Space>bi<TT><Esc>ea</TT><Esc>
vmenu &HTML.&Formats.&Typerwriter	<Esc>`>a</TT><Esc>`<i<TT><Esc>l
imenu &HTML.&Formats.&Typerwriter	<TT>TEXT</TT><Esc>3bcw

nmenu &HTML.&List.&Unordered\ List	O<UL><CR><Tab><LI> <CR><P><CR><C-D></UL><Esc>2kA
vmenu &HTML.&List.&Unordered\ List	<Esc>`>a<CR></UL><Esc>:'<+1,'>+1s/^/    <LI>/<CR>`<i<UL><CR>    <LI><Esc>/<LI><.ul><CR>4x4X
imenu &HTML.&List.&Unordered\ List	<CR><UL><CR><Tab><LI> <CR><P><CR><C-D></UL><Esc>2kA

nmenu &HTML.&List.&Ordered\ List	O<OL><CR><Tab><LI> <CR><P><CR><C-D></OL><Esc>2kA
vmenu &HTML.&List.&Ordered\ List	<Esc>`>a<CR></OL><Esc>:'<+1,'>+1s/^/    <LI>/<CR>`<i<OL><CR>    <LI><Esc>/<LI><.ul><CR>4x4X
imenu &HTML.&List.&Ordered\ List	<CR><OL><CR><Tab><LI> <CR><P><CR><C-D></OL><Esc>2kA

nmenu &HTML.&List.&Directory\ List	O<DIR><CR><Tab><LI> <CR><P><CR><C-D></DIR><Esc>2kA
vmenu &HTML.&List.&Directory\ List	<Esc>`>a<CR></DIR><Esc>:'<+1,'>+1s/^/    <LI>/<CR>`<i<DIR><CR>    <LI><Esc>/<LI><.DIR><CR>4x4X
imenu &HTML.&List.&Directory\ List	<CR><DIR><CR><Tab><LI> <CR><P><CR><C-D></DIR><Esc>2kA

nmenu &HTML.&List.De&finition		O<DT>TERM<CR><DD>DEFINITION<Esc>5bcw
vmenu &HTML.&List.De&finition		<Esc>`>a<CR><DD>DEFINITION <Esc>`<i<DT><Esc>5wcw
imenu &HTML.&List.De&finition		<DT>TERM<CR><DD>DEFINITION<Esc>5bcw

nmenu &HTML.&List.Definition\ &List	O<DL><CR><Tab><LI> <CR><P><CR><C-D></DL><Esc>2kA
vmenu &HTML.&List.Definition\ &List	<Esc>`>a<CR>    <DD>DEFINITION<CR><BS><BS><BS><BS></DL><Esc>`<i<DL><CR>    <DT><Esc>l
imenu &HTML.&List.Definition\ &List	<CR><DL><CR><Tab><LI> <CR><P><CR><C-D></DL><Esc>2kA

nmenu &HTML.&Table 					mq<Bar>i<TABLE><CR><Tab><THEAD><CR><TR><CR><Tab><TH> </TH><CR><C-D></TR><CR></THEAD><CR><TR><CR><Tab><TD> </TD><CR><C-D></TR><CR><C-D></TABLE><CR><Esc><Bar>'q+
imenu &HTML.&Table 					<Esc>mq<Bar>i<TABLE><CR><Tab><THEAD><CR><TR><CR><Tab><TH> </TH><CR><C-D></TR><CR></THEAD><CR><TR><CR><Tab><TD> </TD><CR><C-D></TR><CR><C-D></TABLE><CR><Esc><Bar>'q+




"
"   Functions
"

" safeguard
if !exists("*s:Start_Cscope")



" Search end of file (last 30 lines)
" for 'Last modified:' line, " and, if found,
" substitute the next line with the current date.
" Dito for 'Modified by:', substitute 'id -un' if found.
" The latter works only under Unix.
" Right now, the "last modified" stuff is commented out,
" because I use the server side include feature #echo
function s:LastModified()

	let l = line("$")
	let ll = l - 30
	if ll < 1
		let ll = 1
	endif

	let l = l - 1
	while l > ll
		if getline(l) =~ '^[lL]ast modified:' && getline(l+1) !~ '#echo'
			" don't replace server-side includes
			call setline( l+1, strftime("%a %b %d %T %Z %Y") )
			break
		endif
		let l = l - 1
	endwhile

	if has("unix")
		let l = line("$")
		while l > ll
			if getline(l) =~ '^[mM]odified by:'
				let l = l + 1
				call setline( l, system("id -un") )

				" kill the \n (
				let lin = getline(l)
				let ch = strpart( lin, strlen(lin)-1, 1 )
				if ch < ' '
					let lin = strpart( lin, 0, strlen(lin)-1 )
					call setline( l, lin )
				endif

				break
			endif
			let l = l - 1
		endwhile
	endif

endfunction

" Former solution (less elegant IMHO):
" The command sequence
"   maHmb (save position) and 'bzt`a (restore position)
" not only restores the cursor position in the file but also the
" position of the cursor line *relative* in the window.



" Insert the appropriate closing HTML tag
" matching the most recent open tag;
" tags not having a closing companion are ignored (see variable UnaryTags).
"
" Clobbers register z and mark z.
" From: csxsdm@scs.leeds.ac.uk (Smylers)

function! s:InsertCloseTag()

  " list of tags which shouldn't be closed:
  let UnaryTags = 'area base br col dd dt hr img input li link meta p param'

  let save_ignorecase = &ignorecase             " match tags in any case
  set ignorecase
  let save_wrapscan = &wrapscan
  set nowrapscan

  " remember current position
  normal mq

  " loop backwards looking for tags
  let found = 0
  while found == 0
	" find previous <, go forward one character and grab the first char
	" plus the entire word it (possibly including that char)
	normal ?<?
    normal l"qyll
    let tg = expand('<cword>')

    if @q == '/'
      " it's a closing tag, skip back to its matching opening tag
      execute "normal ?<" . tg . "
"

    elseif match(UnaryTags, tg) >0
      " it's a unary tag, position the cursor for the next iteration
      normal h

    else
      " it's a tag that needs closing
      let found = 1

    endif
  endwhile

  " create the closing tag and insert it:
  let @q = '</' . tg . '>'
  normal `q"qp

  let &ignorecase = save_ignorecase
  let &wrapscan = save_wrapscan

endfunction

" end of safeguard
endif



" restore
let &cpo = s:save_cpo
unlet s:save_cpo

