#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <bstring.h>
#include <sys/types.h>
#include <unistd.h>

#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <termio.h>

#include <netdb.h>

#ifndef WINS			/* Usually want this... */
#include <netinet/in.h>
#else				/* ... but need these for WINS. */
#include <sys/in.h>
#include <sys/inet.h>
#endif

#include <errno.h>

#ifdef __sgi
/* not sure where this is located on other unices */
#include <arpa/inet.h>
#endif

#include <fcntl.h>
#ifndef FD_ZERO
#include <sys/select.h>
#endif

#include "igc.h"
#include "parse.h"

char servename[80];
int serveport;
int sock;
static char inbuf[10000];
int inptr = 0;
int doecho = 1;


void sethost(s)
char *s;
{
   strcpy(servename, s);
}


void setport(s)
int s;
{
   serveport = s;

}

void close_connection()
{
   close(sock);
}


FILE *log = NULL;



int open_connection()
{
   struct sockaddr_in server;
   struct hostent *hp;
   int ipn;

   printf("Opening connection to %s %d\n", servename, serveport);

   if ( do_log )
   {
      int d;
      char n[444];
      d = 0;
      do {
	 sprintf(n, "log%d.igc", d);
	 log = fopen(n, "r");
	 if (!log)
	 {
	    log = fopen(n, "w");
	    if (log)
	       fprintf(stderr,"Creating log file %s\n", n);
	    else
	    {
		perror("fopen");
		fprintf(stderr,"Cannot create log file %s.\n", n );
	    }
	    break;
	 }
	 fclose(log);
	 d++;
	 if (d > 9) {
	    fprintf(stderr,"Too many log files. Delete log files (log?.igc)? ");
	    fgets(n, 443, stdin);
	    if (n[0] != 'Y' && n[0] != 'y')
	       exit(1);
	    for (d = 0; d < 10; d++) {
	       sprintf(n, "dump%d.igc", d);
	       unlink(n);
	    }
	    log = fopen("log0.igc", "w");
	    if (!log) {
		perror("fopen");
	       fprintf(stderr,"File open error.  Cannot create log file\n");
	       exit(1);
	    }
	    break;
	 }
      } while (1);
   }

   if (sscanf(servename, "%d.%d.%d.%d", &ipn, &ipn, &ipn, &ipn) == 4)
      server.sin_addr.s_addr = inet_addr(servename);
   else {
      hp = gethostbyname(servename);
      if (hp == 0) {
	 puts("Unknown host");
	 return -1;
      }
      bcopy(hp->h_addr, &server.sin_addr, hp->h_length);
   }
   server.sin_family = AF_INET;
   server.sin_port = htons(serveport);
   sock = socket(AF_INET, SOCK_STREAM, 0);
   if (sock < 0) {
      perror("socket");
      return -1;
   }
   if (connect(sock, (struct sockaddr *) & server,
	       sizeof(struct sockaddr_in)) < 0) {
      perror("connect");
      return -1;
   }
   return 0;
}



void sendstr(buf)
char *buf;
{
    if ( log )
	if ( strlen(buf) && buf[0] != '\377' )
	    fprintf( log, ">%s<\n", buf );

   write(sock, buf, strlen(buf));
}


void setecho(ec)
int ec;
{
   struct termio termdescr;		/* terminal description of port */
   doecho = ec;

    if (ioctl(0, TCGETA, &termdescr) < 0)
    {
	perror("igc: setecho: ioctl(get):");
	return;
    }

   if (ec)
	termdescr.c_lflag |= ECHO;
   else
	termdescr.c_lflag &= ~ECHO;

    if ( ioctl(0, TCSETA, &termdescr) < 0 )
    {
	perror("igc: setecho: ioctl(set):");
	return;
    }
}



/* This function written by Mike Dobbins */
/* Returns 1 if telnet processing ate the character. */

#define IAC '\377'
#define DONT '\376'
#define DO '\375'
#define WONT '\374'
#define WILL '\373'
#define AYT '\366'
#define TELOPT_SGA  '\3'
#define TELOPT_ECHO '\1'


int dotelnet(ch)
char ch;
{
   static int telsgal = -1;
   static int telsgar = -1;
   static int telcount = 0;
   static char telchars[4];

   if (ch == IAC || telcount == 1) {
      telchars[telcount] = ch;
      telcount++;
      if (telcount == 2 && telchars[1] == AYT) {
	 telcount = 0;
	 sendstr("ayt\n");
	 return 0;
      }
      return 1;
   }
   if (telcount == 2) {
      telcount = 0;
      telchars[2] = ch;
      telchars[3] = 0;
      switch (telchars[2]) {
#ifndef GATEWAY
	 case TELOPT_ECHO:
	    if (telchars[1] == WILL && doecho) {
	       setecho(0);
	       telchars[1] = DO;
	       sendstr(telchars);
	    } else if (telchars[1] == WONT && !doecho) {
	       setecho(1);
	       telchars[1] = DONT;
	       sendstr(telchars);
	    } else if (telchars[1] == DO) {
	       telchars[1] = WONT;
	       sendstr(telchars);
	       break;
	    }
	    break;
#endif
	 case TELOPT_SGA:
	    if (telchars[1] == WILL && telsgar < 1) {
	       telsgar = 1;
	       telchars[1] = DO;
	       sendstr(telchars);
	    } else if (telchars[1] == WONT && telsgar != 0) {
	       telsgar = 0;
	       telchars[1] = DONT;
	       sendstr(telchars);
	    } else if (telchars[1] == DO && telsgal < 1) {
	       telsgal = 1;
	       telchars[1] = WILL;
	       sendstr(telchars);
	    } else if (telchars[1] == DONT && telsgal != 0) {
	       telsgal = 0;
	       telchars[1] = WONT;
	       sendstr(telchars);
	    }
	    break;
	 default:
	    if (telchars[1] == WILL) {
	       telchars[1] = DONT;
	       sendstr(telchars);
	    } else if (telchars[1] == DO) {
	       telchars[1] = WONT;
	       sendstr(telchars);
	    }
	    break;
      }
      if (telsgar < 0) {
	 telsgar = 1;
	 telchars[1] = DO;
	 telchars[2] = TELOPT_SGA;
	 sendstr(telchars);
      } else if (telsgal < 0) {
	 telsgal = 1;
	 telchars[1] = WILL;
	 telchars[2] = TELOPT_SGA;
	 sendstr(telchars);
      }
      return 1;
   }
   return 0;
}




int handlechar(retbuf, in)
char *retbuf;
char in;
{
   if (in == '\r')
      return 0;
   if (dotelnet(in))
      return 0;

   if ( log )
       fputc(in, log);

   if (in == '\n') {
      inbuf[inptr] = 0;
      strcpy(retbuf, inbuf);
      inptr = 0;
      return 1;
   } else {
      inbuf[inptr++] = in;
      if (doneline(inbuf, inptr)) {
	 inbuf[inptr] = 0;
	 strcpy(retbuf, inbuf);
	 inptr = 0;
	 return 1;
      }
   }
   return 0;
}



int bufdata = 0, bufptr = 0;
char thebuf[1000];

int pollserver(retbuf, checkstdin)
char *retbuf;
int checkstdin;
{
   int sel;
   fd_set readers;

   FD_ZERO(&readers);
   while (1) {
      while (bufdata) {
	 bufdata--;
	 if (handlechar(retbuf, thebuf[bufptr++]))
	    return 1;
      }
      bufptr = 0;
      if (checkstdin)
	 FD_SET(0, &readers);	/* Check stdin */
      FD_SET(sock, &readers);
      sel = select(sock + 1, &readers, NULL, NULL, (struct timeval *) 0);
      if (sel == -1) {
	 if (errno != EINTR) {	/* ^Z will do this */
	    perror("select");
	    return -1;
	 }
	 continue;
      }
      if (FD_ISSET(sock, &readers)) {
	 bufdata = read(sock, thebuf, 1000);
	 if (!bufdata)
	    return -1;
	 if (bufdata < 0) {
	    perror("read");
	    return -2;
	 }
      } else if (FD_ISSET(0, &readers))
	 return KEY;
   }
}

