#include "igc.h"
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include "numbers.h"

extern char *getloginname();
extern char *getpassword();
int loggedon, verbosetog;
int repeatpass, repeatlogin;

char *Prompts[] =
{
   "Login: ",
   "Password: ",
   "Password: ",
   "Enter Your Password Again: ",
   "Enter your e-mail address (None): ",
   "#> ",
   "#> ",
   "Enter Dead Group: ",
   "#> ",
   "#> ",
};


void initparser()
{
   loggedon = 0;
   repeatpass = 0;
   repeatlogin = 0;
   verbosetog = 0;
}


int DoState(s)
char *s;
{
   if (strncmp(s, Prompts[LOGON], strlen(Prompts[LOGON])) == 0)
      return LOGON;
   if (strncmp(s, "1 1", 3) == 0)
      return PASSWORD;
   if (strncmp(s, "1 0", 3) == 0)
      return LOGON;
   if (strncmp(s, Prompts[PASSWORD], strlen(Prompts[PASSWORD])) == 0)
      return PASSWORD;
   if (strncmp(s, Prompts[PASSWD_NEW], strlen(Prompts[PASSWD_NEW])) == 0)
      return PASSWD_NEW;
   if (strncmp(s, Prompts[PASSWD_CONFIRM],
	       strlen(Prompts[PASSWD_CONFIRM])) == 0)
      return PASSWD_CONFIRM;
   if (strncmp(s, Prompts[WAITING], strlen(Prompts[WAITING])) == 0)
      return WAITING;
   if (!strncmp(s, "Too many players, sorry", 23) ||
       !strncmp(s, "Sorry, the server is full", 24))
      return TOOMANY;
   return -1;
}


void parsegame(mesg, str)
message *mesg;
char *str;
{
   int fieldcount;
   char *br, *wr, blackrank[10], whiterank[10];
   if (str[1] == '#') {
      mesg->gamecount = 0;
      strcpy(mesg->text, str);
      strcpy(mesg->gamefirst, str);
      mesg->lines = 1;
   } else {
      strcpy(mesg->gamelist[mesg->gamecount].gametext, str);
      strcat(mesg->gamelist[mesg->gamecount].gametext, "\n");
      strcat(mesg->text, "\n");
      strcat(mesg->text, str);
      mesg->lines++;

      /* hacked for systems that don't like %[^]] */
      for (br = str; *br; br++)
	 if (*br == ']')
	    *br = '!';
      fieldcount = sscanf(str, "[%d!%12s [%[^!]! vs.%12s [%[^!]! (%3d %d %d %f %d%*c%*c%*c) ( %d)\n",
			  &(mesg->gamelist[mesg->gamecount].gnum),
			  mesg->gamelist[mesg->gamecount].white,
			  whiterank,
			  mesg->gamelist[mesg->gamecount].black,
			  blackrank,
			  &(mesg->gamelist[mesg->gamecount].mnum),
			  &(mesg->gamelist[mesg->gamecount].bsize),
			  &(mesg->gamelist[mesg->gamecount].hcap),
			  &(mesg->gamelist[mesg->gamecount].komi),
			  &(mesg->gamelist[mesg->gamecount].byo),
			  &(mesg->gamelist[mesg->gamecount].obcount));
      br = blackrank;
      wr = whiterank;
      if (*br == ' ')
	 br++;
      if (*wr == ' ')
	 wr++;
      strcpy(mesg->gamelist[mesg->gamecount].wrank, wr);
      strcpy(mesg->gamelist[mesg->gamecount].brank, br);
      if (fieldcount == 11)
	 (mesg->gamecount)++;
   }
}


void parsemove(s, mess)
char *s;
message *mess;
{
   int mc, y, mv;
   char c, col;
   extern int boardsize;

   if (!strncmp(s, "Game ", 5)) {
      sscanf(s, "Game %d %*c: %*[^(](%d %d %d) vs %*[^(](%d %d %d)",
	     &(mess->gamenum), &(mess->wcap), &(mess->wtime),
	     &(mess->wbyo), &(mess->bcap),
	     &(mess->btime), &(mess->bbyo));
      mess->movecount = 0;
      return;
   }
   mc = sscanf(s, "%3d(%c): %c%d", &mv, &c, &col, &y);
   if (mc == 3) {
      if (3 == sscanf(s, "%3d(%c): Handicap %d", &mv, &c, &mc)) {
	 mess->moves[mess->movecount].x = mess->moves[mess->movecount].y = mc + 100;
	 mess->moves[mess->movecount].color = c == 'W' ? 2 : 1;
	 mess->moves[mess->movecount].movenum = mv + 1;
	 mess->movecount++;
	 return;
      }
      if (2 == sscanf(s, "%3d(%c): Pass", &mv, &c)) {
	 mess->moves[mess->movecount].x = mess->moves[mess->movecount].y = 99;
	 mess->moves[mess->movecount].color = c == 'W' ? 2 : 1;
	 mess->moves[mess->movecount].movenum = mv + 1;
	 mess->movecount++;
	 return;
      }
   }
   if (col > 'I')
      col--;
   mess->moves[mess->movecount].x = col - 'A';
   mess->moves[mess->movecount].y = boardsize - y;
   mess->moves[mess->movecount].color = c == 'W' ? 2 : 1;
   mess->moves[mess->movecount].movenum = mv + 1;
   mess->movecount++;
}


static long appending = 0;

int getmessage(mess, checkstdin)
message *mess;
int checkstdin;
{
   char mesg[2000];
   int ret;
   char *textpart;

   ret = pollserver(mesg, checkstdin);

   if (ret <= 0)
      return ret;

   switch (DoState(mesg)) {
      case PASSWD_NEW:
      case PASSWD_CONFIRM:
      case PASSWORD:
	 sendstr(getpassword(repeatpass++));
	 break;
      case WAITING:
	 sendstr("toggle client true\n");
	 mess->id = ONSERVER;
	 loggedon = 1;
	 return 1;
      case TOOMANY:
	 mess->id = TOOMANY;
	 return 1;
      case LOGON:
	 {
	    int needlogin = 1;
            int guest = 0;
	    do {
	       if (needlogin == 1) {
		  sendstr(getloginname(repeatlogin++));
		  needlogin = -1;
	       }
	       ret = pollserver(mesg, 0);
	       if (ret < 0)
		  return ret;
	       if (strstr(mesg, "guest account")){
                  puts(mesg);
		  guest=1;
		  needlogin=0;
		} else
	       if (!strncmp(mesg, "Password:", 9) || (!strncmp(mesg, "1 1", 3)))
		  needlogin = 0;
	       else if (!strncmp(mesg, "Sorry", 5)) {
		  puts(mesg);
		  if (!strncmp(mesg, "Sorry, the server is full", 24)) {
		     mess->id = TOOMANY;
		     return 1;
		  }
		  return 0;
	       } else if (strlen(mesg) > 2 && strncmp(mesg, "Login", 5)){
		  if (*mesg=='9') puts(mesg+2); 
		  else puts(mesg);
		}
	    } while (needlogin);
            if (guest) needlogin=1; 
            else sendstr(getpassword(repeatpass++));
	    do {
	       ret = pollserver(mesg, 0);
	       if (ret < 0)
		  return ret;
	       if (!strncmp(mesg, "Enter", 5))
		  sendstr(getpassword(repeatpass++));
	       if (!strncmp(mesg, "9 File", 6))
		  needlogin = -1;
	       if (!strncmp(mesg, "To get", 6))
		  needlogin = 1;
	       if (!strncmp(mesg, "#>", 2)) {
		  sendstr("toggle client true\n");
		  mess->id = ONSERVER;
		  loggedon = 1;
		  return 1;
	       }
	       if (strstr(mesg, "Invalid") || strstr(mesg, "your name")
                  || strstr(mesg, "name is") 
		 || strstr(mesg, "Too few") || strstr(mesg, "do not match")) {
		  if (*mesg == '5')
		     puts(mesg + 2);
		  else
		     puts(mesg);
		  needlogin = 1;
	       }
	    } while (!needlogin);
	    if (needlogin > 0)
	       break;
	 }
	 loggedon = 1;
			/* intentional fall through occurs here */

      default:
	 mess->id = strtol(mesg, &textpart, 10);
	 if (!loggedon && strcmp("1 5",mesg)) {
	    mess->id = INTRO;
	    strcpy(mess->text, mesg);
	    return 1;
	 }
	 textpart++;
	 if (mess->id == 2 && (strstr(textpart, "Game")
			       || strstr(textpart, "min")))
	    mess->id = TIMEREP;
	 if (appending == -1) {
	    if (mess->id && !strncmp(textpart, "File", 4)) {
	       appending = 0;
	       if (mess->id == INFO &&
		   !strncmp(mess->text, "~~~~~~~~~~~~~~~~~~~~~", 21)){
		  mess->id = QUITMESG;
		  loggedon = 0;
		}
	       return 1;
	    }

	    if (strlen(mess->text)) {
	       strcat(mess->text, "\n");
	       mess->lines++;
	    }

	    {
	       int len;
	       char *pt;
	       len = strlen(mesg);
	       pt = mesg;
	       while (len > 0) {
		  strncat(mess->text, pt, 79);
		  len -= 79;
		  pt += 79;
		  if (len > 0) {
		     mess->lines++;
		     strcat(mess->text, "\n");
		  }
	       }
	    }
	    return 0;
	 }
	 if (mess->id == PROMPT) {
            if (!verbosetog) 
	       sendstr("toggle verbose false\n");
	    if (*textpart == '5' && !loggedon)
	       loggedon = 1;
	    if (appending == MOVE && mess->movecount == 0 &&
		atoi(textpart) == 6 /* TEACHING */ ) {
	       mess->id = MATCH;
	       return 1;
	    }
	    if (appending) {
	       mess->id = appending;
	       appending = 0;
	       return 1;
	    }
	    mess->prompttype = atoi(textpart);
	 }

	 if (!strcmp(textpart, "File")) {
	    appending = -1;
	    strcpy(mess->text, "");
	    mess->lines = 1;
	    return 0;
	 }
	 if (mess->id == BEEP) {
	    mess->beep = (*textpart == 7);
	 }
	 if (mess->id == KIBITZ) {
	    if (parsekibitz(textpart, mess))
	       return 0;
	 }
	 if (mess->id == UNDO)
	    if (ret = parseundo(textpart, &(mess->gamenum))) {
	       if (ret < 0)
		  return ret;
	       return 0;
	    }
	 if (mess->id == SCORE_M) {
	    sscanf(textpart, "%[^ ] (W:%*c):%f to %[^ ] (B:%*c):%f",
		   mess->white, &(mess->wscore), mess->black, &(mess->bscore));
	    return 1;
	 }
	 if (mess->id == TRANS) {
	    if (appending) {
	       strcat(mess->text, "\n");
	       strcat(mess->text, textpart);
	       mess->lines++;
	    } else {
	       strcpy(mess->text, textpart);
	       mess->lines = 1;
	    }
	    appending = TRANS;
	    return 0;
	 }
	 if (mess->id == MOVE) {
	    appending = MOVE;
	    parsemove(textpart, mess);
	    return 0;
	 }
	 if (mess->id == WHO)
	    return parsewho(mess, textpart);
	 if (mess->id == GAMES) {
	    appending = GAMES;
	    parsegame(mess, textpart);
	    return 0;
	 }
	 if (mess->id == STATUS)
	    return parsestatus(mess, textpart);
	 strcpy(mess->text, textpart);
	 mess->lines = 1;
         if (mess->id == SHOUT) {
            checkgame(textpart, mess);
	    return 1;
         }
	 if (mess->id == ERROR &&
	     !strcmp("Game not found.", textpart)) {
	    mess->id = GAMES;
	    mess->gamecount = 0;
	    return 1;
	 }
	 if (mess->id == INFO)
	    if (ret = parseinfo(textpart, mess))
	       return ret;
	 return 1;
   }
   return 0;

}


int parsestatus(mesg, s)
message *mesg;
char *s;
{
   int line, i;
   char wflag, bflag;

   if (1 == sscanf(s, " %d:", &line)) {
      mesg->boardsize = line + 1;
      for (i = 0, s += 4; *s; i++, s++)
      {
	 switch (*s)
	 {
	    case S_BLACK:
	       mesg->board[line][i] = BLACK;
	       break;
	    case S_WHITE:
	       mesg->board[line][i] = WHITE;
	       break;
	    case S_EMPTY:
	    case S_HOSHI:
	       mesg->board[line][i] = EMPTY;
	       break;
	    case S_WTERR:
	       mesg->board[line][i] = WTERR;
	       break;
	    case S_BTERR:
	       mesg->board[line][i] = BTERR;
	       break;
	    case S_DAME:
	       mesg->board[line][i] = DAME;
	       break;
	 }
      }
      if (i == line + 1)
	 return 1;
   } else {
      if (!mesg->wnext) {
	 sscanf(s, "%[^ ] %[^ ] %d %d %d %c %f %d",
		mesg->white, mesg->wrank, &(mesg->bcap), &(mesg->wtime),
		&(mesg->wbyo), &wflag, &(mesg->mykomi), &(mesg->hcap));
	 if (wflag == 'F')
	    mesg->wbyo = -1;
      } else {
	 sscanf(s, "%[^ ] %[^ ] %d %d %d %c %f %d",
		mesg->black, mesg->brank, &(mesg->wcap), &(mesg->btime),
		&(mesg->bbyo), &bflag, &(mesg->mykomi), &(mesg->hcap));
	 if (bflag == 'F')
	    mesg->bbyo = -1;
      }
      mesg->wnext = !mesg->wnext;
   }
   return 0;
}

#define WHOLENGTH 34


int parsewho(mesg, str)
message *mesg;
char *str;
{
   if (!strncmp(str, " Info", 5)) {
      mesg->whocount = 0;
      strcpy(mesg->text, str);
      mesg->lines = 1;
      strcpy(mesg->whofirst, str);
   } else {
      strcat(mesg->text, "\n");
      strcat(mesg->text, str);
      mesg->lines++;
      if (strstr(str, "******")) {
	 strcpy(mesg->wholast, str);
	 return 1;
      } else {
	 strncpy(mesg->who[mesg->whocount++], str, WHOLENGTH);
	 if (strlen(str) > 40 && mesg->whocount < MAXWHO )
	    strncpy(mesg->who[mesg->whocount++], str + 37, WHOLENGTH);
	 if ( mesg->whocount >= MAXWHO )
	 {
	     strcpy( mesg->wholast, "too many users !\n" );
	     return 1;
	 }
      }
   }
   return 0;
}



int parseinfo(s, mess)
char *s;
message *mess;
{
   int ret;
   extern int boardsize;
   int row;
   char col;
   char text[100];

   if (checkgame(s, mess))
   {
       mess->id = ENDGAMEINFO;
       return 0;
   }
   if (!strcmp(s, "Set verbose to be False.")) {
      mess->id = 0;
      verbosetog = 1;
      return 0;
   }
   if (!strcmp(s, "Set verbose to be True.")) {
      mess->id = 0;
      verbosetog = 0;
      return 0;
   }
   if (1 == sscanf(s, "Set the komi to %f.", &(mess->mykomi))) {
      mess->id = CHKOMI;
      return 0;
   }
   if (2 == sscanf(s, "Match [%dx%d]", &ret, &ret))
      return 0;
   if (1 == sscanf(s, "Match [%d]", &(mess->gamenum))) {
      mess->id = MATCH;
      return 0;
   }
   if (1 == sscanf(s, "Creating match [%d]", &(mess->gamenum))) {
      mess->id = MATCH;
      return 0;
   }
   if (2 == sscanf(s, "Removing @ %c%d", &col, &row)) {

      if (col > 'I')
	 col--;
      mess->x = col - 'A';
      mess->y = boardsize - row;
      mess->id = REMOVE;
      return 0;
   }
   if (!strcmp(s, "Type 'done' when finished")) {
      mess->id = STARTSCORE;
      return 0;
   }
   if (!strncmp(s, "Board is restored", 17)) {
      mess->id = SCOREUNDO;
      return 0;
   }
   if (strstr(s, "has restored your old game.")) {
      char eat = 3, match = 0;
      mess->id = LOAD;
      for (; eat; eat--) {
	 ret = pollserver(text, 0);
	 if (ret < 0)
	    return ret;
	 if (!match)
	    match = sscanf(text, "%*d Game %d: %*[^(](%d %d %d) vs %*[^(](%d %d %d)",
			   &(mess->gamenum), &(mess->bcap), &(mess->btime),
		   &(mess->bbyo), &(mess->wcap), &(mess->wtime), &(mess->wbyo)
	       );
      }
      return 0;
   }
   return 0;
}


int parseundo(s, gamenum)
char *s;
int *gamenum;
{
   char mes[2000];
   int count;
   int bogus2, ret;
   char bogus1;
   count = sscanf(s, "%*[^ ] undid the last move (%c%d).", &bogus1, &bogus2);
   if (count == 2) {
      ret = pollserver(mes, 0);
      if (ret < 0)
	 return ret;
      ret = pollserver(mes, 0);
      if (ret < 0)
	 return ret;
      sscanf(mes, "%*d Game %d", gamenum);
      ret = pollserver(mes, 0);
      if (ret < 0)
	 return ret;
      return 0;
   }
   if (1 == sscanf(s, "%*[^ ] undid the last move (Handicap %d).", &bogus2))
      return 0;
   count = sscanf(s, "Undo in game %d", gamenum);
   if (count != 1)
      return 1;			/* extra line */
   return 0;
}


int checkgame(s, mess)
char *s;
message *mess;
{ 
   if ( !strncmp(s,"{Game ",6) &&
	( strstr(s,"resigns.") ||  
	  strstr(s,"forfeits on time.") || strstr(s, "adjourned.")))
   {
     mess->id = ENDGAME;
     sscanf(s, "{Game %d", &(mess->gamenum));
     return 1;
   } 
   return 0;
}
     

int parsekibitz(s, mess)
char *s;
message *mess;
{
   if (1 == sscanf(s, "Kibitz %[^:]", mess->kibitzer))
      return 1;
   while (*s == ' ')
      s++;
   strcpy(mess->kibitz, s);
   return 0;

}



int doneline(inbuf, inptr)
char *inbuf;
int inptr;
{
   return !loggedon &&
      (inptr > 0 && inbuf[inptr - 1] == ' ') &&
      ( inptr==10 && !strncmp(inbuf,"Password: ",10) ||
        inptr==7 && !strncmp(inbuf,"Login: ",7) ||
       (inptr > 2 && inbuf[inptr - 2] == '>' && inbuf[inptr - 3] == '#'));
}
