
typedef enum {
	UNKNOWN	=  0,
	AUTOMAT	=  35, 	/* Automatch anouncement*/
	ADJOURN = 48,	/* Multigame adjourn	*/
	AUTOASK	=  36, 	/* Automatch accept	*/
	CAPTURE =  47,	/* Capture messages	*/
	CHOICES = 38, 	/* game choices		*/
	CLIVRFY = 41,	/* Client verify message */
	BEEP	=  2, 	/* \7 telnet 		*/
	BOARD	=  3,	/* Board being drawn 	*/
	DOWN	=  4,	/* The server is going down */
	ERROR	=  5,	/* An error reported	*/
      	FIL	=  6,	/* File being sent	*/
	FOLLOWS	= 45, 	/* A follow pl messages.*/
	GAMES	=  7,	/* Games listing	*/
	GOERR	= 50,	/* An error in a move 	*/
      	HELP	=  8,	/* Help file		*/
	IGS	= 46,	/* multi listing of players. */
	INFO	=  9,	/* Generic info		*/
	LAST	= 10,	/* Last command		*/
      	KIBITZ	= 11,	/* Kibitz strings	*/
	LOAD	= 12,	/* Loading a game	*/
	LOOK_M	= 13,	/* Look 		*/
      	MESSAGE	= 14,	/* Message lising	*/
      	MOVE	= 15,	/* Move #:(B) A1	*/
	OBSERVE	= 16,	/* Observe report	*/
      	PROMPT	=  1,	/* A Prompt (never)	*/
	REFRESH	= 17,	/* Refresh of a board	*/
	REGLOG	= 44, 	/* The reregister reg log. */
	REMOVING = 49, 	/* Multigame stone removal */
      	SAVED	= 18,	/* Stored command	*/
      	SAY	= 19,	/* Say string		*/
	SAY_MG	= 51, 	/* Say multigame	<-- last */
      	SCORE_M	= 20,	/* Score report		*/
	SGF_F	= 43,	/* SGF command output   */
	SGF_M	= 34,	/* SGF file     	*/
      	SHOUT	= 21,	/* Shout string		*/
      	SHOW 	= 29,	/* Shout string		*/
      	STATUS	= 22,	/* Current Game status	*/
	STORED	= 23,	/* Stored games		*/
      	TEACH	= 33,	/* teaching game	*/
      	TELL	= 24,	/* Tell string		*/
      	DOT	= 40,	/* your . string	*/
	THIST	= 25,	/* Thist report		*/
	TIM	= 26,	/* times command	*/
	TRANS	= 30,	/* Translation info	*/
	TTT_BOARD= 37, 	/* tic tac toe		*/
	WHO	= 27,	/* who command		*/
	UNDO	= 28,	/* Undo report		*/
	USER	= 42,	/* Long user report	*/
	VERSION = 39,	/* IGS VERSION: IGS entry on %02d - %02d - %04d\r\n
				 comes out just as the last piece of info
				 after verification of the password.
				 mm - dd - yyyy <== last Message Type value */
	YELL	= 32,	/* Channel yelling	*/
	MAXMSGTYP = 52,	/* 1-st invalid type, added by me (GZ) */
			/* have to adjust probably in the future, when more */
			/* message types are added by IGS */
} MessageType;

#ifdef GLOBALS

char *mesgtypestr[] =
{
"UNKNOWN",	/* UNKNOWN	=  0 */
"PROMPT",	/* PROMPT	=  1 */
"BEEP",		/* BEEP	=  	2 */
"BOARD",	/* BOARD	=  3 */
"DOWN",		/* DOWN	=  	4 */
"ERROR",	/* ERROR	=  5 */
"FIL",		/* FIL	=  	6 */
"GAMES",	/* GAMES	=  7 */
"HELP",		/* HELP	=  	8 */
"INFO",		/* INFO	=  	9 */
"LAST",		/* LAST	= 	10 */
"KIBITZ",	/* KIBITZ	= 11 */
"LOAD",		/* LOAD	= 	12 */
"LOOK_M",	/* LOOK_M	= 13 */
"MESSAGE",	/* MESSAGE	= 14 */
"MOVE",		/* MOVE	= 	15 */
"OBSERVE",	/* OBSERVE	= 16 */
"REFRESH",	/* REFRESH	= 17 */
"SAVED",	/* SAVED	= 18 */
"SAY",		/* SAY	= 	19 */
"SCORE_M",	/* SCORE_M	= 20 */
"SHOUT",	/* SHOUT	= 21 */
"STATUS",	/* STATUS	= 22 */
"STORED",	/* STORED	= 23 */
"TELL",		/* TELL		= 24 */
"THIST",	/* THIST	= 25 */
"TIM",		/* TIM		= 26 */
"WHO",		/* WHO		= 27 */
"UNDO",		/* UNDO		= 28 */
"SHOW",		/* SHOW 	= 29 */
"TRANS",	/* TRANS	= 30 */
"31",
"YELL",		/* YELL		= 32 */
"TEACH",	/* TEACH	= 33 */
"SGF_M",	/* SGF_M	= 34 */
"AUTOMAT",	/* AUTOMAT	=  35 */
"AUTOASK",	/* AUTOASK	=  36 */
"TTT_BOARD",	/* TTT_BOARD	= 37 */
"CHOICES",	/* CHOICES 	= 38 */
"VERSION",	/* VERSION 	= 39 */
"DOT",		/* DOT		= 40 */
"CLIVRFY",	/* CLIVRFY 	= 41 */
"USER",		/* USER		= 42 */
"SGF_F",	/* SGF_F	= 43 */
"REGLOG",	/* REGLOG	= 44 */
"FOLLOWS",	/* FOLLOWS	= 45 */
"IGS",		/* IGS		= 46 */
"CAPTURE",	/* CAPTURE 	=  47 */
"ADJOURN",	/* ADJOURN 	= 48 */
"REMOVING",	/* REMOVING 	= 49 */
"GOERR",	/* GOERR	= 50 */
"SAY_MG",	/* SAY_MG	= 51 */
"52",
"53",
};

#endif /* GLOBALS */


#define    S_BLACK  '0'
#define    S_WHITE  '1'
#define    S_EMPTY  '2'
#define    S_DAME   '3'
#define    S_WTERR  '4'
#define    S_BTERR  '5'
#define    S_HOSHI  '6'


#define LOGGEDON WAITING
typedef enum {
	LOGON		= 0,  /* initial state */
	PASSWORD	= 1,  /* getting password */
	PASSWD_NEW	= 2,  /* verifiying password: not used, registration */
	PASSWD_CONFIRM	= 3,  /* ditto */
	REGISTER	= 4,  /* not used */
	WAITING		= 5,  /* After login the basic state */
	PLAYING		= 6,  /* Playing a game */
	SCORING		= 7,  /* Scoring a game */
	OBSERVING	= 8,  /* Observing (and playing?) a game */
	TEACHING	= 9,  /* In teaching mode, can move for W and B */
	COMPLETE	= 10  /* game complete */
} State;

