#include "igc.h"

typedef char boardtype[19][19];
int prisoners[2];
int movenum, maxmove;

typedef struct {
   int x, y;
   char col;
}  movelist[500];

movelist moves;

boardtype board;

#define boolean char
#define false 0
#define true 1

static int boardsize = -1;

int lasti = -1, lastj = -1;


void clearboard(b, pris)
boardtype b;
int *pris;
{
   int i, j;
   pris[0] = pris[1] = 0;
   for (i = 0; i < boardsize; i++)
      for (j = 0; j < boardsize; j++)
	 b[i][j] = EMPTY;
}


void initboard(size)
int size;
{
   clearboard(board, prisoners);
   unhighlight(lasti, lastj);
   showhcap(0);
   initAscii();
   initBoardAscii(size);
   boardsize = size;
   maxmove = movenum = 0;
}


void reinitboard(size)
int size;
{
   unhighlight(lasti, lastj);
   showhcap(0);
   clearboard(board, prisoners);
   initAscii();
   reinitboardascii();
   boardsize = size;
}

boolean inRange(i, j)
{
   return i >= 0 && i < boardsize && j >= 0 && j < boardsize;
}

boolean alive0(b, m, i, j, t)
boardtype b;
boardtype m;
int i, j;
piece t;
{
   piece pt;

   pt = b[i][j];
   if ((pt != EMPTY && pt != t) || m[i][j] != EMPTY)
      return 0;
   m[i][j] = (pt == t) ? (piece) 1 : (piece) 2;
   if (pt == EMPTY)
      return 1;
   return
      (j < boardsize - 1 && alive0(b, m, i, j + 1, t)) ||
      (i < boardsize - 1 && alive0(b, m, i + 1, j, t)) ||
      (i && alive0(b, m, i - 1, j, t)) ||
      (j && alive0(b, m, i, j - 1, t));
}

boolean alive(b, i, j)		/* Does group at i,j have liberties? */
boardtype b;
int i, j;
{
   boardtype m;
   int p[2];

   clearboard(m, p);
   return alive0(b, m, i, j, b[i][j]);
}

int removed;
int dontdraw = 0;

void removeStones0(b, pris, i, j, t)
boardtype b;
int *pris;
int i, j;
piece t;
{
   if (b[i][j] != t)
      return;
   b[i][j] = EMPTY;
   if (!dontdraw)
      drawStone(i, j, 0);
   removed = 1;
   pris[t - 1]++;
   if (j < boardsize - 1)
      removeStones0(b, pris, i, j + 1, t);
   if (i < boardsize - 1)
      removeStones0(b, pris, i + 1, j, t);
   if (i)
      removeStones0(b, pris, i - 1, j, t);
   if (j)
      removeStones0(b, pris, i, j - 1, t);
}



void removeStones(b, pris, i, j)
boardtype b;
int *pris;
int i, j;
{
   removed = 0;
   removeStones0(b, pris, i, j, b[i][j]);
   /* if (removed) boardrefresh(); */

}


void removeGroup(i, j)
int i, j;
{
   removeStones(board, prisoners, i, j);
}

boolean tryKill(b, pris, i, j, t)
boardtype b;
int *pris;
int i, j;
piece t;
{
   piece w;
   if (!inRange(i, j))
      return false;
   w = b[i][j];
   if (w != EMPTY && w != t && !alive(b, i, j)) {
      removeStones(b, pris, i, j);
      return true;
   }
   return false;
}

void placeStone(b, pris, i, j, t)
boardtype b;
int *pris;
int i, j;
piece t;
{
   if (inRange(i, j)) {
      b[i][j] = t;
      if (j)
	 tryKill(b, pris, i, j - 1, t);
      if (j < boardsize - 1)
	 tryKill(b, pris, i, j + 1, t);
      if (i)
	 tryKill(b, pris, i - 1, j, t);
      if (i < boardsize - 1)
	 tryKill(b, pris, i + 1, j, t);
   }
}


#define TOP 0
#define MID 1
#define BOT 2
static int verts[3][26] =
{
   {0, 0, 0, 0, 0, 0, 0, 0, 0,
    2, 0, 0, 0, 3, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 4},
   {0, 0, 0, 0, 0, 0, 0, 0, 0,
    4, 0, 0, 0, 6, 0, 0, 0, 0, 0, 9, 0, 10, 0, 0, 0, 12},
   {0, 0, 0, 0, 0, 0, 0, 0, 0,
    6, 0, 0, 0, 9, 0, 0, 0, 0, 0, 15, 0, 17, 0, 0, 0, 20},
};

void sethandicap(board, hand)
boardtype board;
int hand;
{
   /* This is also used to set the handicap.  The 'handi' is the number of
    * things to set of piece 'p'. */

   int top, mid, bot;
   piece t;

   top = verts[TOP][boardsize];
   mid = verts[MID][boardsize];
   bot = verts[BOT][boardsize];

   /* All of these drop through, '5' checks for odd points. */
   t = 1;
   switch (hand) {
      case 9:			/* taken care of by handi == 5 */
      case 8:
	 drawStone(mid, top, t);
	 board[mid][top] = t;
	 drawStone(mid, bot, t);
	 board[mid][bot] = t;
      case 7:			/* taken care of by handi == 5 */
      case 6:
	 drawStone(bot, mid, t);
	 board[bot][mid] = t;
	 drawStone(top, mid, t);
	 board[top][mid] = t;
      case 5:
	 if (hand & 0x1) {	/* odd points, test because of drop through */
	    drawStone(mid, mid, t);
	    board[mid][mid] = t;
	 }
      case 4:
	 drawStone(bot, bot, t);
	 board[bot][bot] = t;
      case 3:
	 drawStone(top, top, t);
	 board[top][top] = t;
      case 2:
	 drawStone(bot, top, t);
	 board[bot][top] = t;
	 drawStone(top, bot, t);
	 board[top][bot] = t;
	 break;
      default:
	 break;
   }
}



void construct(mov)
int mov;
{
   int i, j;
   boardtype myboard;
   int mypris[2];

   if (mov > maxmove)
      mov = maxmove;
   if (mov < 1)
      mov = 1;
   clearboard(myboard, mypris);
   unhighlight(lasti, lastj);
   dontdraw = 1;
   for (i = 1; i <= mov; i++) {
      if (moves[i].x > 100)
	 sethandicap(myboard, moves[i].x - 100);
      else if (moves[i].x != 99) {
	 placeStone(myboard, mypris, moves[i].x, moves[i].y, moves[i].col);
	 myboard[moves[i].x][moves[i].y] = moves[i].col;
      }
   }
   dontdraw = 0;
   for (i = 0; i < boardsize; i++)
      for (j = 0; j < boardsize; j++)
	 if (board[i][j] != myboard[i][j]) {
	    drawStone(i, j, myboard[i][j]);
	    board[i][j] = myboard[i][j];
	 }
   prisoners[0] = mypris[0];
   prisoners[1] = mypris[1];
   highlight(moves[mov].x, moves[mov].y, mov, moves[mov].col,
	     -1, -1, -1, -1);
   lasti = moves[mov].x;
   lastj = moves[mov].y;
   drawpris(prisoners);
   movenum = mov;
}



static int highlighting = 1;

void makemove(i, j, num, t, btime, bbyo, wtime, wbyo)
int i, j;
piece t;
int btime, bbyo, wtime, wbyo;
{
   if (movenum != maxmove) {
      construct(maxmove);
   }
   if (highlighting)
      unhighlight(lasti, lastj);
   if (num == 1 && i <= 19)
      showhcap(0);
   if (i > 100) {
      sethandicap(board, i - 100);
      showhcap(i - 100);
      moves[num].x = moves[num].y = i;
      moves[num].col = t;
      maxmove = movenum = num;
      if (highlighting)
	 highlight(i, j, num, t, btime, bbyo, wtime, wbyo);
      return;
   }
   if (i == 99) {
      moves[num].x = moves[num].y = 99;
      moves[num].col = t;
      maxmove = movenum = num;
      if (highlighting) {
	 highlight(i, j, num, t, btime, bbyo, wtime, wbyo);
	 drawpris(prisoners);
      }
      return;
   }
   placeStone(board, prisoners, i, j, t);
   if (highlighting)
      highlight(i, j, num, t, btime, bbyo, wtime, wbyo);
   if (highlighting)
      drawpris(prisoners);
   if (highlighting)
      drawOneStone(i, j, t);
   else
      drawStone(i, j, t);
   lasti = i;
   lastj = j;
   moves[num].x = i;
   moves[num].y = j;
   moves[num].col = t;
   maxmove = movenum = num;
}


void unmark()
{
   unmarkascii(lasti, lastj);
}



int savemaxmove = 0, didsave = 0;


void restoremaxmoves()
{
   didsave = 0;
   maxmove = savemaxmove;
}

void savemaxmoves()
{
   if (!didsave) {
      didsave = 1;
      savemaxmove = maxmove;
   }
}


void showboard(b)
boardtype b;
{
   int i, j;
   for (i = 0; i < boardsize; i++)
      for (j = 0; j < boardsize; j++)
	 if (board[i][j] != b[i][j]) {
	    drawStone(i, j, b[i][j]);
	    board[i][j] = b[i][j];
	 }
   boardrefresh();
}


void undo()
{
   int i, j;

   maxmove--;
   if (maxmove)
      construct(maxmove);
   else {
      movenum = 0;
      unhighlight(lasti, lastj);
      for (i = 0; i < boardsize; i++)
	 for (j = 0; j < boardsize; j++)
	    if (board[i][j] != EMPTY) {
	       drawStone(i, j, EMPTY);
	       board[i][j] = EMPTY;
	    }
   }
}


int forward(num)
int num;
{
   if (!maxmove)
      return 1;
   if (movenum < maxmove)
      construct(movenum + num);	/* construct() does bounds checking */
   return 0;
}


int backward(num)
int num;
{
   if (!maxmove)
      return 1;
   if (movenum > 1)
      construct(movenum - num);	/* construct() does bounds checking */
   return 0;
}


int beginninggame()
{
   if (!maxmove)
      return 1;
   construct(1);
   return 0;
}

int endgame()
{
   if (!maxmove)
      return 1;
   construct(maxmove);
   return 0;
}


int search(i, j)
int i, j;
{
   int k;
   k = maxmove;
   while (k > 0 && (moves[k].x != i || moves[k].y != j))
      k--;
   if (!k)
      return 1;
   construct(k);
   return 0;
}


void sethighlight(h)
int h;
{
   highlighting = h;
}


