
#include <curses.h>

#include "igc.h"
#include "ascii.h"

#define TOP 2
#define LEFT 3
#define RIGHT 79
#define min(a,b) (((a)<(b))?(a):(b))
#define TITLEX 6
#define HIGHLIGHT 23

#define   CHAR_NOTHING 0
#define   CHAR_BLACK 1
#define   CHAR_WHITE 2
#define   CHAR_DAME 3
#define   CHAR_BLACKTERR 4
#define   CHAR_WHITETERR 5
#define   CHAR_HANDICAP 6
#define   CHAR_VERT 7
#define   ASC_NUMCHARS 8


WINDOW *boardwin, *serverwin, *iowin;
char xAxisChars[] = "ABCDEFGHJKLMNOPQRST";
int inverseFlag = 1;
int inverseBorder = 0;
int lastwin = 1;
int boardsize = -1;
char chars[] = ".#O?+-+ ";
int servecols = -1;
static int init = 0;
int endw = -1, endb = -1;
int reinit = 0;
int doedgemarkers = 0;
int dopiecemarkers = 1;


void setedgemark(mark)
int mark;
{
   doedgemarkers = mark;
}

void setpiecemark(mark)
int mark;
{
   dopiecemarkers = mark;
}

void setinverse(inv)
int inv;
{
   inverseFlag = inv;
}

void setinverseborder(inv)
int inv;
{
   inverseBorder = inv;
}

void setborder(ch)
char ch;
{
   chars[CHAR_VERT] = ch;
}

void setchars(s)
char *s;
{
   int i;
   for (i = 0; i <= min(CHAR_VERT, strlen(s) - 1); i++)
      chars[i] = s[i];
}


void serverrefresh()
{
   if (lastwin)
      wrefresh(iowin);
   else
      wrefresh(serverwin);
}

void boardrefresh()
{
   wrefresh(boardwin);
}

void initAscii()
{
   if (!init) {
      init = 1;
      initscr();
      noecho();
      crmode();
   }
}

void suspend()
{
   move(23, 0);
   refresh();
   echo();
   nocrmode();
}



void redraw()
{
   clearok(stdscr, TRUE);
   refresh();
   clearok(stdscr, FALSE);
}


void unsuspend()
{
   noecho();
   crmode();
   redraw();
}


void displaygamenumber(n)
int n;
{
   move(0, 0);
   if (n >= 0)
      printw("%3d", n);
   else if (n == -1)
      printw("-- ");
   else
      printw("sta");
   refresh();
}

void boardtitle(bs, ws)
char *bs, *ws;
{
   int i;
   move(0, TITLEX);
   for (i = 0; i < 35; i++)
      addch(' ');
   move(1, TITLEX);
   for (i = 0; i < 35; i++)
      addch(' ');
   if (strlen(bs)) {
      move(0, TITLEX);
      printw("Black: %s", bs);
      endb = TITLEX + 8 + strlen(bs);
      move(1, TITLEX);
      printw("White: %s", ws);
      endw = TITLEX + 8 + strlen(ws);
   }
   refresh();
}

static void sbinverse()
{
   if (inverseBorder)
      wstandout(boardwin);
}

static void set_inverse()
{
   if (inverseFlag)
      wstandout(boardwin);
}

static void unset_inverse()
{
   wstandend(boardwin);
}


void setcursor(x, y)
int x, y;
{
   wmove(boardwin, TOP + y, LEFT + 2 * x);
   wrefresh(boardwin);
}


void drawPiece(i, j, c)
int i, j;
char c;
{
   wmove(boardwin, TOP + j, LEFT + 2 * i);
   set_inverse();
   waddch(boardwin, c);
   unset_inverse();
}


void deleteBoardAscii()
{
   delwin(boardwin);
   delwin(serverwin);
   delwin(iowin);
}


void endAscii()
{
   init = 0;
   deleteBoardAscii();
   boardsize = -1;
   clear();
   refresh();
   echo();
   nocrmode();
   endwin();
}


char boardPiece(x, y, boardsize)
int x, y, boardsize;
{
   return

      (((boardsize == 19 && x == 9) || (boardsize >= 10 &&
					(x == 3 || x == boardsize - 4))
	|| (boardsize > 6 && boardsize < 10 &&
	    (x == 2 || x == boardsize - 3))) &&
       ((boardsize == 19 && y == 9) ||
	(boardsize >= 10 && (y == 3 || y == boardsize - 4))
	|| (boardsize > 6 && boardsize < 10 &&
	    (y == 2 || y == boardsize - 3))))
      ? chars[(int) CHAR_HANDICAP] : chars[(int) CHAR_NOTHING];
}



void drawOneStone(i, j, t)
int i, j;
piece t;
{
   if (t == 0)
      drawPiece(i, j, boardPiece(i, j, boardsize));
   else
      drawPiece(i, j, chars[t]);
   wrefresh(boardwin);
}

void drawStone(i, j, t)
int i, j;
piece t;
{
   if (t == 0)
      drawPiece(i, j, boardPiece(i, j, boardsize));
   else
      drawPiece(i, j, chars[t]);
}


void unmarkascii(i, j)
int i, j;
{
   if (!init)
      return;
   if (i >= 0 && i <= 19) {
      set_inverse();
      if (dopiecemarkers) {
	 wmove(boardwin, TOP + j, LEFT + 2 * i - 1);
	 waddch(boardwin, ' ');
	 wmove(boardwin, TOP + j, LEFT + 2 * i + 1);
	 waddch(boardwin, ' ');
      }
      if (doedgemarkers) {
	 wmove(boardwin, TOP + j, LEFT - 1);
	 waddch(boardwin, chars[CHAR_VERT]);
	 wmove(boardwin, TOP + j, LEFT + boardsize * 2 - 1);
	 waddch(boardwin, chars[CHAR_VERT]);
	 unset_inverse();
	 sbinverse();
	 wmove(boardwin, TOP - 1, LEFT + i * 2);
	 waddch(boardwin, xAxisChars[i]);
	 wmove(boardwin, TOP + boardsize, LEFT + i * 2);
	 waddch(boardwin, xAxisChars[i]);
      }
      unset_inverse();
   }
}

void unhighlight(i, j)
int i, j;
{
   int k;
   if (!init)
      return;
   move(HIGHLIGHT, 0);
   for (k = 1; k < 80 - servecols; k++)
      addch(' ');
   move(0, TITLEX - 2);
   printw("  ");
   move(1, TITLEX - 2);
   printw("  ");
   unmarkascii(i, j);
}

static char *who[] =
{"Black", "White"};

void showhcap(hcap)
int hcap;
{
   if (!init)
      return;
   move(0, LEFT + 19 * 2 + 1);
   if (hcap)
      printw("%d", hcap);
   else
      addch(' ');
   refresh();
}

void showkomi(komi)
float komi;
{
   if (!init)
      return;
   move(1, LEFT + 19 * 2 - 1);
   printw("%1.1f", komi);
   refresh();
}

void highlight(i, j, num, t, btime, bbyo, wtime, wbyo)
int i, j, num;
piece t;
int btime, bbyo, wtime, wbyo;
{
   int k;
   if (btime != -1) {
      move(0, endb);
      if (btime < 0)
	 btime = 0;
      if (wtime < 0)
	 wtime = 0;
      printw("%d:%02d", btime / 60, btime % 60);
      if (bbyo != -1)
	 printw(", %d", bbyo);
      addstr("   ");
      move(1, endw);
      printw("%d:%02d", wtime / 60, wtime % 60);
      if (wbyo != -1)
	 printw(", %d", wbyo);
      addstr("   ");
   }
   if (t >= 0) {
      move(t == 1 ? 1 : 0, TITLEX - 2);
      printw("->");
   }
   move(HIGHLIGHT, 0);
   for (k = 1; k < 80 - servecols; k++)
      addch(' ');
   if (i == 99) {
      move(HIGHLIGHT, 0);
      printw("%s #%d Pass", who[t - 1], num);
   } else if (i < 100 && num) {
      move(HIGHLIGHT, 0);
      printw("%s #%d at %c%d", who[t - 1], num, i + 'A' +
	     (i + 'A' >= 'I' ? 1 : 0), boardsize - j);
      set_inverse();
      if (dopiecemarkers) {
	 wmove(boardwin, TOP + j, LEFT + 2 * i - 1);
	 waddch(boardwin, '>');
	 wmove(boardwin, TOP + j, LEFT + 2 * i + 1);
	 waddch(boardwin, '<');
      }
      if (doedgemarkers) {
	 wmove(boardwin, TOP + j, LEFT - 1);
	 waddch(boardwin, '>');
	 wmove(boardwin, TOP + j, LEFT + boardsize * 2 - 1);
	 waddch(boardwin, '<');
	 unset_inverse();
	 sbinverse();
	 wmove(boardwin, TOP - 1, LEFT + i * 2);
	 waddch(boardwin, '!');
	 wmove(boardwin, TOP + boardsize, LEFT + i * 2);
	 waddch(boardwin, '!');
      }
      unset_inverse();
   }
}



void drawpris(pris)
int *pris;
{
   move(23, 22);
   printw("Captured %c: %d  %c: %d  ", chars[CHAR_BLACK], *pris,
	  chars[CHAR_WHITE], pris[1]);
   refresh();
}



void initBoardAscii(size)
int size;
{
   int i, j;
   if (!reinit) {
      if (size == boardsize) {
	 for (i = boardsize; i--;)
	    for (j = boardsize; j--;)
	       drawStone(i, j, 0);
	 return;
      }
      if (boardsize != -1)
	 deleteBoardAscii();
      boardsize = size;
      clear();
      boardwin = subwin(stdscr, boardsize + 4, boardsize * 2 - 1 + 6 + 2, 1, 0);
      servecols = COLS - 19 * 2 - 6 - 2;
      serverwin = subwin(stdscr, 22, servecols, 0, 19 * 2 - 1 + 6 + 2);

      iowin = subwin(stdscr, 2, servecols, 22, 19 * 2 - 1 + 6 + 2);
   }
   if (inverseFlag || reinit) {
      set_inverse();
      for (i = LEFT + 1; i < LEFT + boardsize * 2 - 2; i += 2)
	 for (j = TOP; j < TOP + boardsize; j++)
	    mvwaddch(boardwin, j, i, ' ');
      unset_inverse();
   }
   for (i = boardsize; i--;) {
      /* left */
      wmove(boardwin, TOP + i, LEFT - 3);
      sbinverse();
      wprintw(boardwin, "%2d", boardsize - i);
      unset_inverse();
      set_inverse();
      waddch(boardwin, chars[(int) CHAR_VERT]);

      /* right */
      wmove(boardwin, TOP + i, LEFT + boardsize * 2 - 1);
      waddch(boardwin, chars[(int) CHAR_VERT]);
      unset_inverse();
      sbinverse();
      wprintw(boardwin, "%2d", boardsize - i);
      unset_inverse();
      waddch(boardwin, chars[(int) CHAR_VERT]);

      /* top */
      wmove(boardwin, TOP - 1, LEFT + i * 2);
      sbinverse();
      waddch(boardwin, xAxisChars[i]);
      waddch(boardwin, ' ');
      unset_inverse();
      wmove(boardwin, TOP - 1, LEFT + i * 2 - 1);
      set_inverse();

      /* bottom */
      wmove(boardwin, TOP + boardsize, LEFT + i * 2 - 1);
      unset_inverse();
      wmove(boardwin, TOP + boardsize, LEFT + i * 2);
      sbinverse();
      waddch(boardwin, xAxisChars[i]);
      waddch(boardwin, ' ');
      unset_inverse();
      for (j = boardsize; j--;)
	 drawStone(i, j, 0);
   }

   sbinverse();
   wmove(boardwin, TOP - 1, LEFT - 3);
   waddstr(boardwin, "   ");
   wmove(boardwin, TOP + boardsize, LEFT - 3);
   waddstr(boardwin, "   ");
   wmove(boardwin, TOP - 1, LEFT + 2 * boardsize);
   waddstr(boardwin, "  ");
   wmove(boardwin, TOP + boardsize, LEFT + 2 * boardsize);
   waddstr(boardwin, "  ");
   unset_inverse();

   wmove(boardwin, size / 2, size / 2);
}

void reinitboardascii()
{
   reinit = 1;
   initBoardAscii(boardsize);
   reinit = 0;
}


void clearserver()
{
   wclear(serverwin);
   wrefresh(serverwin);
}


void addcharline(pos, ch)
int pos;
char ch;
{
   wmove(iowin, 1, pos);
   waddch(iowin, ch);
   wrefresh(iowin);
   lastwin = 1;
}


void deletechar(pos)
int pos;
{
   wmove(iowin, 1, pos);
   waddch(iowin, ' ');
   wmove(iowin, 1, pos);
   wrefresh(iowin);
   lastwin = 1;
}


int linesize()
{
   return servecols - 1;
}

void clrline()
{
   wmove(iowin, 1, 0);
   wclrtoeol(iowin);
   wrefresh(iowin);
}


void addchar(ch)
char ch;
{
   int x, y, maxx, maxy;
   if (ch == '\r')
      return;
   waddch(serverwin, ch);
   maxy = serverwin->_maxy - 1;	/* 20 */
   maxx = serverwin->_maxx - 1;	/* servecols - 1; */
   getyx(serverwin, y, x);
   if ((x == maxx - 1 && y == maxy) || (ch == '\n' && y == maxy) ||
       y > maxy) {
      wmove(serverwin, 0, 0);
      wclrtoeol(serverwin);
   } else if (x == 0 && y <= maxy) {
      wclrtoeol(serverwin);
      wmove(serverwin, y + 1, 0);
      wclrtoeol(serverwin);
      wmove(serverwin, y, x);
   }
   wrefresh(serverwin);
   lastwin = 0;
}

void showprefix(s)
char *s;
{
   wmove(iowin, 0, 0);
   wclrtoeol(iowin);
   if (strlen(s))
      wprintw(iowin, "Prefix: '%s'", s);
   wrefresh(iowin);
}


/* addstring(s) char *s; { char *p; for (p = s; *p; p++) addchar(*p); } */


void addstring(s)
char *s;
{
   char *wordstart;
   char *curptr;
   int haveblank, linelen;

   curptr = wordstart = s;
   linelen = 0;
   while (*curptr) {
      while (*curptr && *curptr != ' ' && *curptr != '\n') {
	 linelen++;
	 curptr++;
      }
      if (*curptr) {
	 haveblank = 1;
	 linelen++;
	 curptr++;
      } else
	 haveblank = 0;

      if (linelen <= linesize()) {
	 while (wordstart != curptr)
	    addchar(*wordstart++);
	 if (haveblank && *(curptr - 1) == '\n')
	    linelen = 0;
      } else if (haveblank && (linelen - 1 <= linesize())) {
	 while (wordstart != curptr - 1)
	    addchar(*wordstart++);
	 addchar('\n');
	 wordstart++;
	 linelen = 0;
      } else {
	 if ((curptr - wordstart) > linesize()) {
	    while ((curptr - wordstart) > linesize()) {
	       int i;
	       for (i = linesize(); i; i--)
		  addchar(*wordstart++);
	       addchar('\n');
	    }
	 } else
	    addchar('\n');

	 linelen = 0;
	 while (wordstart != curptr) {
	    addchar(*wordstart++);
	    linelen++;
	 }

      }
   }
}


void bigmessboard(lines, intext)
int lines;
char *intext;
{
   WINDOW *savescr;
   char ch;
   int i, count;
   int rest;
   char *mynl, *text;

   text = (char *) malloc(strlen(intext) + 1);
   strcpy(text, intext);
   mynl = "";
   if (lines > 22) {
      rest = lines;
      lines = 22;
   } else
      rest = 0;
   savescr = newwin(24, 80, 0, 0);
   overwrite(stdscr, savescr);
   do {
      if (rest > 0) {
	 for (mynl = text, count = 22; count && *mynl; mynl++)
	    if (*mynl == '\n')
	       count--;
	 *(mynl - 1) = 0;
	 rest -= 22;
      }
      for (i = (24 - lines) / 2 - 1; i < (24 - lines) / 2 + lines + 1; i++) {
	 move(i, 0);
	 clrtoeol();
      }
      move((24 - lines) / 2, 0);
      addstr(text);
      refresh();
      while (read(0, &ch, 1) != 1);
      text = mynl;
   } while (rest > 0);
   overwrite(savescr, stdscr);
   refresh();
   delwin(savescr);
}


void bigmessserv( int lines, char *intext)
{
   char ch;
   int count;
   int rest;
   char *mynl, *text;
   struct termio termdescr, termdescr_save; /* terminal description of port */

   text = (char *) malloc(strlen(intext) + 1);
   if ( ! text )
   {
	fprintf(stderr,"bigmessserv: malloc(%d) failed!\n", strlen(intext)+1 );
   	myexit(0);
   }

   /* put term into non-canonical mode */
   if (ioctl( fileno(stdin), TCGETA, &termdescr) < 0)
       perror("bigmessserv: ioctl(0,tcgeta)");
   else
   {
       termdescr_save = termdescr;

       /*termdescr.c_iflag = 0;*/
       termdescr.c_lflag &= ~ICANON;
       termdescr.c_lflag &= ~ECHO;
       termdescr.c_cc[VMIN] = 1;
       termdescr.c_cc[VTIME]= 0;

       if (ioctl( fileno(stdin), TCSETA, &termdescr) < 0)
	   perror("bigmessserv: ioctl(0,tcseta)");
   }

   strcpy(text, intext);
   if (lines > 22) {
      rest = lines;
      lines = 22;
   } else
      rest = 0;
   mynl = "";
   do {
      if (rest > 0) {
	 for (mynl = text, count = 22; count && *mynl; mynl++)
	    if (*mynl == '\n')
	       count--;
	 *(mynl - 1) = 0;
	 rest -= 22;
      }
      puts(text);
      if ( rest > 0 )
	  while (read(0, &ch, 1) != 1);
      text = mynl;
   } while (rest > 0);

   if ( ioctl( fileno(stdin), TCSETA, &termdescr_save) < 0)
       perror("bigmessserv: ioctl(0,tcseta,save)");

   putchar('\n');

}


void bigmess( int lines, char *intext )
{
    extern int boardon;

    if ( boardon )
	bigmessboard( lines, intext );
    else
	bigmessserv( lines, intext );

}
