/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 * GtkMultiRowSel Copyright (C) 2000 Stefan Ondrejicka <ondrej@idata.sk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GTK_MULTIROWSEL_H__
#define __GTK_MULTIROWSEL_H__

#include <gdk/gdk.h>
#include "gtkmultirow.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_MULTIROWSEL(obj)          GTK_CHECK_CAST (obj, gtk_multirowsel_get_type (), GtkMultiRowSel)
#define GTK_MULTIROWSEL_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_multirowsel_get_type (), GtkMultiRowSelClass)
#define GTK_IS_MULTIROWSEL(obj)       GTK_CHECK_TYPE (obj, gtk_multirowsel_get_type ())


typedef struct _GtkMultiRowSel       GtkMultiRowSel;
typedef struct _GtkMultiRowSelClass  GtkMultiRowSelClass;


struct _GtkMultiRowSel
{
	GtkMultiRow		multirow;

	GtkSelectionMode	selection_mode;

	GdkGC			*sel_gc;
	GdkSegment		sel_box;
	gboolean		selecting;
	gboolean		viewport_parent;

	gboolean		redrawing;
};

struct _GtkMultiRowSelClass
{
        GtkMultiRowClass parent_class;
};


guint           gtk_multirowsel_get_type	(void);
GtkWidget*      gtk_multirowsel_new		(gint			nrows);
GSList*		gtk_multirowsel_get_selection	(GtkMultiRowSel		*mrs);
GtkWidget*	gtk_multirowsel_get_selected	(GtkMultiRowSel		*mrs);
void		gtk_multirowsel_set_selected_all(GtkMultiRowSel 	*mrs,
						 gboolean		selected);
void		gtk_multirowsel_kill_selection	(GSList			*selection);
void 		gtk_multirowsel_set_selection_mode(GtkMultiRowSel	*mrs,
						 GtkSelectionMode	mode);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GTK_MULTIROWSEL_H__ */
