/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999 Ondrejicka Stefan			   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef chbg_config_h_
#define chbg_config_h_

#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtktooltips.h>
#include "absimg.h"
#include "gui_tools.h"

#ifdef GETTEXT_NLS

#define CATALOG_NAME	PACKAGE
#include <libintl.h>
#include <locale.h>
#ifdef LC_MESSAGES
#define INIT_LOCALE \
        setlocale(LC_MESSAGES, "");\
        setlocale(LC_CTYPE, "");\
        bindtextdomain(CATALOG_NAME, NLS_DIR);\
        textdomain(CATALOG_NAME);\
        gdk_set_locale();
#else
#define INIT_LOCALE \
        setlocale(LC_CTYPE, "");\
        bindtextdomain(CATALOG_NAME, NLS_DIR);\
        textdomain(CATALOG_NAME);\
        gdk_set_locale();
#endif

#else
#define gettext(x) x
#define INIT_LOCALE
#endif
#define gettext_nop(x) x

#define CHBG_EFECTS 29
#define CHBG_BANNER_MODES 14
#define CHBG_EXTERNOPENER 15

#define MODE_DESKTOP		0
#define MODE_WINDOW		1
#define MODE_SCREENSAVER	2
#define MODE_XSCREENSAVER	3
#define MODE_ENLIGHTENMENT	4

typedef enum {
	THUMB_NONE = 0,
	THUMB_ALL,
	THUMB_PAGE,
	THUMB_DIR,
	THUMB_SA
} thumb_type;

typedef enum {
	SHADE_COLORS,
	SHADE_TILES,
	SHADE_GRADIENTS
} shading_type;

typedef enum {
	RENDERT_TILE ,
	RENDERT_MIRROR ,
	RENDERT_CENTER ,
	RENDERT_MAXIMIZE ,
	RENDERT_SMART ,
	RENDERT_CENTER_TILE ,
	RENDERT_INT_TILE ,
	RENDERT_SYM_TILE ,
	RENDERT_INT_MIRROR ,
	RENDERT_SYM_MIRROR ,
} rendering_type;

#define default_max_grow 1.0	/*** maximal grow ratio ***/
#define default_interval 5	/*** time for which will picture stay on screen ***/
#define default_max_size 90	/*** maximal size of picture in % of screen size ***/
#define default_type RENDERT_SMART	/*** type of picture rendering ***/
#define default_efect 0
#define default_shader 0
#define default_speed 100
#define default_fract_iter 30
#define default_box_size 16

#ifndef MIN
#define MIN(x,y) ((x) < (y) ? (x) : (y))
#endif

#ifndef MAX
#define MAX(x,y) ((x) > (y) ? (x) : (y))
#endif

#define SET_TOOLTIP(w,t) gtk_tooltips_set_tip(chbg_tooltips, w, t, NULL)

typedef struct {
	gfloat	max_grow;
	guint	max_size;
	gfloat	xpos;
	gfloat	ypos;
	gushort	mode;
} banner_prop_t;

typedef struct {
	char		*name;
	banner_prop_t	*prop;
} banner_t;

typedef struct {
	gfloat		max_grow;
	gfloat		interval;
	gfloat		interval_end;
	rendering_type	type;
	guint		efect;
	guint		max_size;
	GdkColor	background;
	GdkColor	background2;
	guint		shade;
	guint		rand_colors;
	guint		use_grad;
	guint		use_tiles;
	guint		use_banners;
	guint		gradnr;
	gfloat		xpos;
	gfloat		ypos;
	char		*tile;
	char		*banner;
	banner_prop_t	banner_prop;
} prop_t;

typedef struct {
	gchar	*name;
	prop_t	*prop;
} picentry_t;

typedef struct {
	int		shadernr;
	gboolean	load;
	guchar		r0;
	guchar		r1;
	guchar		g0;
	guchar		g1;
	guchar		b0;
	guchar		b1;
	int		gradnr;
	char		*tile;
} randshader_info;

typedef struct {
	prop_t		properties;
	GList		*pics;
	GList		*pics_orig;
	guint		num_pics;
	guint		screensaver;
	guint		xscreensaver;
	guint		blank;
	guint		setup;
	guint		randomize;
	guint		recurse;
	guint		speed;
	gchar		*scenario;
	guint		inwindow;
	guint		infwindow;
	guint		use_ebg;
	glong		windowid;
	guint		runit;
	GSList		*pattern;
	guint		cycle_blank;
	guint		min_size;
	GSList		*d_effects;
	GSList		*d_shaders;
	guint		tooltips;
	guint		box_size;
	guint		fract_iter;
	gchar		*grad_dir;
	GSList		*grads;
	char		*current_name;
	guint		remember_last;
	guint		sort;
	guint		once;
	thumb_type	thumb;
	GList		*tiles;
	GList		*banners;
	guint		tofile;
	gchar		*outfile;
	guint		outfile_width;
	guint		outfile_height;
	gint		fake_nautilus;
	gint		send_expose;
	gint		force_xscreensaver;
	gint		print_fname;
	gint		use_cache;
	gchar		*log_file;
} cfg_param;


extern banner_t *banner_clone(char *, banner_t *);
extern banner_t *banner_new(char *);
extern void banner_free(banner_t *);
extern char * banner_get_name(banner_t *);

extern banner_prop_t *banner_prop_new(void);
extern banner_prop_t *banner_prop_dup(banner_prop_t *);
extern void banner_prop_free(banner_prop_t *);

extern char * picentry_get_name(picentry_t *);
extern void picentry_free(picentry_t *);
extern picentry_t *picentry_new(char *);
extern picentry_t *picentry_dup(picentry_t *);
extern picentry_t *picentry_clone(char *, picentry_t *);

extern prop_t *prop_dup(prop_t *);
extern prop_t *prop_copy(prop_t *, prop_t *);
extern void prop_free(prop_t *);

extern int makealldirs(char *);
extern int check_program(char *);
extern char *simplify_path(char *);

extern gint cfg_cmdln(guint , gchar **);
extern gint cfg_scenario(gchar *);
extern gint cfg_save_scenario(gchar *);
extern void cfg_default(void);
extern void cfg_clear(void);
extern void cfg_usage(gchar *);
extern void cfg_save_prop(void);
extern void cfg_load_prop(void);
extern void cfg_add_default_prop(void);

extern void run_setup(guint *, gchar ***);

extern void chbg_status_what(char *, int);
extern void chbg_status_set(char *, prop_t *);
extern void chbg_status_clear(void);
extern void chbg_status_progress(int, int);

extern void load_pictures(void);
extern void load_tiles(void);
extern void load_banners(void);

extern void ThumbPreview();
extern void ThumbPreviewPerPage();
extern void ThumbPreviewPerDir();
extern void ThumbViewSA(char *);
extern void ThumbViewFullSA(char *);
extern void ThumbViewPictureList(char *, void *);

extern void ShadersPreview();

extern void SetingsDo();

extern void KillAll();
extern void KillWin();
extern GtkWidget *toplevel_window;
extern GtkWidget *picture_list;
extern GtkTooltips *chbg_tooltips;
extern gboolean stop_changing;

extern void shader_shade_pixmap(prop_t *, GdkPixmap *, GdkGC *, gint, gint, gint, randshader_info *, absimg_rgb_t *);
extern int shader_get_cnt(void);

extern int set_root_bg_real(GdkWindow **, absimg_image_t  *, gchar *imgname,
							prop_t *, absimg_rgb_t **, guint, guint, gint);
extern int set_root_bg(char *, prop_t *);

extern void set_pixmap_property(GdkWindow *, GdkPixmap *, guint, guint, prop_t *);

extern GdkWindow *chbg_init_full_win(GdkWindow *, void *, void *);

extern unsigned char check_for_enlightenment(void);

extern void ext_scale_image_dlg(gboolean, GSList *);
extern void ext_convert_image_dlg(gboolean, GSList *);

extern void banner_render_to_rgb(absimg_rgb_t *, char *);

extern void chbg_srand(unsigned int);
extern int chbg_rand(void);

extern cfg_param cfg;

#ifdef HAVE_ESETROOT_SUPPORT
void esetroot_pixmap_property(GdkWindow *, GdkPixmap *, guint, guint, prop_t *);
#endif

#ifdef HAVE_XSS_SUPPORT
#include <X11/Xlib.h>
extern GdkWindow *xss_get_window(void);
extern Window chwin_get_window(void);

#ifdef GDK_ROOT_PARENT
#undef GDK_ROOT_PARENT
#endif
#define GDK_ROOT_PARENT() xss_get_window()
#endif

#endif
