/*

 For my purposes (overlay over Powerpoint), LSBackgroundOnly must be on, and LSUIElement must be off.
 For normal windows, both should be off.
 
 The goal: 
 -  a transparent window using Cocoa that is always on top of all other windows;
 -  a button with which one can toggle the mouse behavior on the "glass canvas";
 -  while the button is pressed, the transparent window captures mouse events;
    while the button is not pressed, the window is click-through;
 -  the toggle button always receives mouse events.
 
 The trick:
 -  setOpaque: NO
 -  semiTransparentBlue = [NSColor colorWithDeviceRed:... alpha:0.5; 
    setBackgroundColor: semiTransparentBlue
 
 Bug:
 The purplish semi-transparent background does not match the size of the CustomView -- I have no idea, why!
 
 Author and Copyright: Gabriel Zachmann, Aug 2009.
 
 */


#import <AppKit/AppKit.h>
#import <AppKit/NSScreen.h>

#import "CustomWindow.h"


@implementation CustomWindow


- (id) initWithContentRect: (NSRect) contentRect styleMask: (NSUInteger) aStyle backing: (NSBackingStoreType) bufferingType defer: (BOOL) flag 
{
    self = [super initWithContentRect: contentRect styleMask: NSTitledWindowMask|NSClosableWindowMask backing: NSBackingStoreBuffered defer: NO];
																	// for styleMask, you will most often want to use 'NSBorderlessWindowMask'
	
    if (self == nil) 
		return nil;
	
	[self setOpaque: NO];											// Turn off opacity so that the parts of the window that are not drawn into are transparent
	[self setBackgroundColor: [NSColor clearColor] ];

	[self setLevel: NSPopUpMenuWindowLevel];						// make window stay on top of (almost) all other windows	
	
	[self setDelegate: self];										// so that clicking the close button calls our windowWillClose: method
	
    return self;
}


- (BOOL) canBecomeKeyWindow 
{
    return YES;
}


- (IBAction) activateDraw: (id) sender
{
	bool draw = [sender state];

	if ( draw )
	{
		NSColor *semiTransparentBlue = [NSColor colorWithDeviceRed:0.0 green:0.0 blue:1.0 alpha:0.1]; 
		[self setBackgroundColor: semiTransparentBlue ];
	}
	else
		[self setBackgroundColor: [NSColor clearColor] ];
		
	[canvas_ setDrawing_: draw];
	[canvas_ setNeedsDisplay: YES];
}


- (void) windowWillClose: (NSNotification *) notification
{
	[NSApp terminate: self];
}


@end




@implementation CustomView

@synthesize circleImage;		

@synthesize drawing_;


- (void) awakeFromNib 
{
    self.circleImage = [NSImage imageNamed: @"circle"];
	currentPoint_ = NSZeroPoint;
}


- (void) dealloc 
{
    [circleImage release];
    [super dealloc];
}



- (void) drawRect: (NSRect) rect 
{
	
	if ( drawing_ )
	{
		NSColor *semiTransparentRed = [NSColor colorWithDeviceRed:1.0 green:0.0 blue:1.0 alpha:0.1]; 
		[semiTransparentRed set];	
	}
	else
		[[NSColor clearColor] set];	
	
    NSRectFill( [self frame] );
	
	[circleImage compositeToPoint: currentPoint_ operation: NSCompositeSourceOver];
	
	[self setNeedsDisplay: YES];
}



- (void) mouseDragged: (NSEvent *) theEvent 
{
	currentPoint_ = [theEvent locationInWindow];
	[self setNeedsDisplay: YES];
}



@end
