
/*****************************************************************************\
 *                              Waterwaves
\*****************************************************************************/

/**
 * @defgroup WaterWavesClasses Water waves effect classes 
 */

/*! @file Waterwaves.h
 *
 *  @brief
 *	 Water waves effect class declarations...
 *   
 *  @author Michael Nolden (michael120@web.de)
 *     
 */

/*
    Copyright  2001 Michael Nolden All Rights Reserved.
 
 	This file is part of GL Effects Framework.
 
    GL Effects Framework is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    GL Effects Framework is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GL Effects Framework; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


/*! @class Waterwaves
 *
 *  @ingroup WaterWavesClasses
 *
 *  @brief Water waves distortion effect
 *
 *  (Only preliminary!) This effect generates a variety of interesting
 *  'waterwave'-like distortions in images mapped onto a rectangular grid,
 *  using harmonic waveforms...  
 *   
 *  
 **/

#ifndef WATERWAVES_H
#define WATERWAVES_H

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

// system library headers
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Local headers

// GLEffect.h must ALWAYS be included!
#include "../main/GLEffect.h" 

//---------------------------------------------------------------------------
//  Forward references
//---------------------------------------------------------------------------

// controls classes

class QTimer;
class QLabel;
class QSlider;

//**************************************************************************
// Water Waves
//**************************************************************************

class Waterwaves: public GLEffect
{
	Q_OBJECT

//---------------------------------------------------------------------------
//  Public Instance Methods
//---------------------------------------------------------------------------
public:

	//! Primary class contructor
	Waterwaves(GLFramework* parent);
	
	//! Destructor
	virtual ~Waterwaves();
	
	//! Creates control widgets that will manipulate effect parameters & behaviour. 
	void createControls(QWidget* parentWindow);

	/** @name Rendering, animation and effect control functions */
	
		//! Stops animation.
		virtual void stop();
		
		//! Starts animation.
		virtual void play();
		
		//! Resets the effect's parameters.
		virtual void reset();

		//! Pauses animation.
		virtual void pause();
		
		//! Effect-specific implementation of the rendering routine.
		virtual void render();

private:
		
		virtual void distance(GLfloat _x, GLfloat _y, GLfloat mx, GLfloat my);

		virtual void texcoords3f(GLfloat x, GLfloat y, GLfloat z);

		virtual void resetGrid();

		virtual void draw3d();

		virtual void computesinusvalues(GLfloat mx, GLfloat my);

		virtual void draw2d();

		virtual void mousePressEvent(QMouseEvent* mEv);

// --------------------------------------------------------------------------
//! @name	Signals:
// @{ 
	
	signals:

// @}

//! @name	Slots:
// @{

public slots:  

private slots:

		void animate();

		void setwavelength(int amp);
		
		void setamplitude(int amp);

		void setred(int r);
		
		void setgreen(int g);
		
		void setblue(int b);

		void setpolygonalphavalue(int value);

		void setdamping(int factor);

		void setresolution(int num);

		void setwavemode(bool enable);

		void setdistortmode(bool enable);

		void setanimationspeed(int value);

// @}

//---------------------------------------------------------------------------
//  Private/Protected Instance Methods
//---------------------------------------------------------------------------

protected:

	//! Initializes effect states and parameters.
	virtual void initialize(); 
	

private:

	QCheckBox* waveBox;
	QCheckBox* distortBox;
	QLabel* wl_label;
	QLabel* amp_label;
	QLabel* damp_label;
	QLabel* red_label;
	QLabel* green_label;
	QLabel* blue_label;
	QLabel* alpha_label;
	QLabel* centers_label;
	QLabel* resolution_label;
	QLabel* animationspeed_label;
	QSlider* wl_slider;
	QSlider* amp_slider;
	QSlider* damp_slider;
	QSlider* red_slider;
	QSlider* green_slider;
	QSlider* blue_slider;
	QSlider* alpha_slider;
	QSlider* centers_slider;
	QSlider* resolution_slider;
	QSlider* animationspeed_slider;

	int i,j;
	GLfloat tx,ty,tz,dist,var;
	GLdouble wavedata[10];
	GLfloat alphav[4];
	GLdouble data[317] [317]; //initializes array that keeps rendered coordinates
	GLfloat r;
	GLdouble amplitude;
	GLfloat wavelength;
	GLfloat damping,dampingfactor;
	GLfloat polygonalphavalue;
	GLint number_of_wavecenters;
	GLfloat alpha;
	GLint res, range;
	bool wavemode, distortmode;
	float redC,greenC,blueC;
	GLuint texture;
	int index,max;
	GLdouble speed;
			
//---------------------------------------------------------------------------
//  Private/Protected Instance Variables
//---------------------------------------------------------------------------

private:

	// Disabled default constructor and assignment operator
	Waterwaves();
	Waterwaves& operator = (const Waterwaves& source);

//@! name Member Variables
//@{

	QTimer* effectTimer;

//---------------------------------------------------------------------------
//  Class methods and variables
//---------------------------------------------------------------------------

};

#endif

