
/*****************************************************************************\
 *                              shadowControls
\*****************************************************************************/
/*! @file ShadowUI.h
 *
 *  @brief
 *	Shadowcaster UI controls class declarations
 *   
 *  @author Moritz Voss
 *     
 */

/*
    Copyright  2001 Moritz Voss All Rights Reserved.
 
 	This file is part of GL Effects Framework.
 
    GL Effects Framework is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    GL Effects Framework is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GL Effects Framework; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
/*! @class shadowControls
 *
 *  @ingroup ShadowCasterClasses
 *
 *  @brief This class encapsulates the control panel for the shadowcaster
 *  effect.
 *
 *  
 **/

#ifndef SHADOWCONTROLS_H
#define SHADOWCONTROLS_H

#include <qvariant.h>
#include <qwidget.h>
class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QCheckBox;
class QComboBox;
class QLabel;
class QPushButton;
class QSlider;
class QTabWidget;

class shadowControls : public QWidget
{ 
    Q_OBJECT

public:
    shadowControls( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~shadowControls();

    QTabWidget* controlTabs;
    QWidget* tab;
    QLabel* directionZ;
    QLabel* positionY;
    QLabel* directionY;
    QLabel* directionLabel_2;
    QLabel* positionZ;
    QLabel* directionX;
    QLabel* directionLabel_3;
    QLabel* colorLabel1;
    QSlider* colorRed;
    QSlider* colorGreen;
    QSlider* colorBlue;
    QSlider* colorAlpha;
    QCheckBox* lightVectors;
    QCheckBox* lightSource;
    QCheckBox* showNormals;
    QCheckBox* aidDepth;
    QComboBox* glossMethod;
    QComboBox* lightDirection;
    QComboBox* lightMethod;
    QCheckBox* lightView;
    QLabel* positionX;
    QLabel* directionLabel;
    QWidget* tab_2;
    QLabel* TextLabel4;
    QLabel* TextLabel4_2_2;
    QLabel* TextLabel4_2_3;
    QLabel* TextLabel4_2_3_2_3;
    QLabel* TextLabel4_2_3_2_2_2;
    QLabel* TextLabel4_2;
    QLabel* TextLabel4_2_3_2;
    QLabel* TextLabel4_2_3_2_2;
    QSlider* amplitudeSlider;
    QSlider* frequencySlider;
    QSlider* falloffSlider;
    QSlider* filterSlider;
    QComboBox* terrainMethod;
    QPushButton* randomButton;
    QWidget* tab_3;
    QLabel* TextLabel1;

};

#endif // SHADOWCONTROLS_H

