
/*****************************************************************************\
 *                             shadowControls
\*****************************************************************************/

/*! @file ShadowUI.cpp
 *
 *  @brief
 *	Shadowcaster effect control class implementation
 *    
 *  @author Moritz Voss
 *  
 */
#include "ShadowUI.h"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qtabwidget.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

/* 
 *  Constructs a shadowControls which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
shadowControls::shadowControls( QWidget* parent,  const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{
    if ( !name )
	setName( "shadowControls" );
    resize( 230, 319 ); 
    setProperty( "minimumSize", QSize( 230, 318 ) );
    setProperty( "caption", tr( "Form1" ) );

    controlTabs = new QTabWidget( this, "controlTabs" );
    controlTabs->setGeometry( QRect( 0, 0, 230, 320 ) ); 

    tab = new QWidget( controlTabs, "tab" );

    directionZ = new QLabel( tab, "directionZ" );
    directionZ->setGeometry( QRect( 130, 200, 90, 20 ) ); 
    directionZ->setProperty( "text", tr( "z-label" ) );

    positionY = new QLabel( tab, "positionY" );
    positionY->setGeometry( QRect( 10, 180, 90, 20 ) ); 
    positionY->setProperty( "text", tr( "y-label" ) );

    directionY = new QLabel( tab, "directionY" );
    directionY->setGeometry( QRect( 130, 180, 90, 20 ) ); 
    directionY->setProperty( "text", tr( "y-label" ) );

    directionLabel_2 = new QLabel( tab, "directionLabel_2" );
    directionLabel_2->setGeometry( QRect( 0, 140, 70, 20 ) ); 
    directionLabel_2->setProperty( "text", tr( "Light Position" ) );

    positionZ = new QLabel( tab, "positionZ" );
    positionZ->setGeometry( QRect( 10, 200, 90, 20 ) ); 
    positionZ->setProperty( "text", tr( "z-label" ) );

    directionX = new QLabel( tab, "directionX" );
    directionX->setGeometry( QRect( 130, 160, 90, 20 ) ); 
    directionX->setProperty( "text", tr( "x-label" ) );

    directionLabel_3 = new QLabel( tab, "directionLabel_3" );
    directionLabel_3->setGeometry( QRect( 0, 230, 60, 20 ) ); 
    directionLabel_3->setProperty( "text", tr( "Visual Aids" ) );

    colorLabel1 = new QLabel( tab, "colorLabel1" );
    colorLabel1->setGeometry( QRect( 0, 50, 140, 20 ) ); 
    colorLabel1->setProperty( "text", tr( "Light Colour / Alpha Intensity" ) );

    colorRed = new QSlider( tab, "colorRed" );
    colorRed->setGeometry( QRect( 10, 70, 20, 60 ) ); 
    colorRed->setProperty( "maxValue", 255 );
    colorRed->setProperty( "orientation", (int)QSlider::Vertical );
    QToolTip::add(  colorRed, tr( "Red colour component" ) );

    colorGreen = new QSlider( tab, "colorGreen" );
    colorGreen->setGeometry( QRect( 40, 70, 20, 60 ) ); 
    colorGreen->setProperty( "maxValue", 255 );
    colorGreen->setProperty( "orientation", (int)QSlider::Vertical );
    QToolTip::add(  colorGreen, tr( "Green colour component" ) );

    colorBlue = new QSlider( tab, "colorBlue" );
    colorBlue->setGeometry( QRect( 70, 70, 20, 60 ) ); 
    colorBlue->setProperty( "maxValue", 255 );
    colorBlue->setProperty( "orientation", (int)QSlider::Vertical );
    QToolTip::add(  colorBlue, tr( "Blue colour component" ) );

    colorAlpha = new QSlider( tab, "colorAlpha" );
    colorAlpha->setGeometry( QRect( 100, 70, 20, 60 ) ); 
    colorAlpha->setProperty( "maxValue", 255 );
    colorAlpha->setProperty( "orientation", (int)QSlider::Vertical );
    QToolTip::add(  colorAlpha, tr( "Alpha (primarily affects visual aids)" ) );

    lightVectors = new QCheckBox( tab, "lightVectors" );
    lightVectors->setGeometry( QRect( 10, 270, 70, 20 ) ); 
    lightVectors->setProperty( "text", tr( "Light Dst" ) );
    lightVectors->setProperty( "checked", QVariant( TRUE, 0 ) );
    QToolTip::add(  lightVectors, tr( "Show thin pin in direction of light vector." ) );

    lightSource = new QCheckBox( tab, "lightSource" );
    lightSource->setGeometry( QRect( 10, 250, 70, 20 ) ); 
    lightSource->setProperty( "text", tr( "Light Pos" ) );
    lightSource->setProperty( "checked", QVariant( TRUE, 0 ) );
    QToolTip::add(  lightSource, tr( "Show light source as gluSphere(...)" ) );

    showNormals = new QCheckBox( tab, "showNormals" );
    showNormals->setGeometry( QRect( 90, 250, 60, 20 ) ); 
    showNormals->setProperty( "text", tr( "Normals" ) );
    showNormals->setProperty( "checked", QVariant( FALSE, 0 ) );
    QToolTip::add(  showNormals, tr( "Visualize surface normals." ) );

    aidDepth = new QCheckBox( tab, "aidDepth" );
    aidDepth->setGeometry( QRect( 160, 250, 60, 20 ) ); 
    aidDepth->setProperty( "text", tr( "Clip Aids" ) );
    aidDepth->setProperty( "checked", QVariant( TRUE, 0 ) );
    QToolTip::add(  aidDepth, tr( "Clip visual aids against surface using GL_DEPTH_TEST" ) );

    glossMethod = new QComboBox( FALSE, tab, "glossMethod" );
    glossMethod->insertItem( tr( "No Gloss" ) );
    glossMethod->insertItem( tr( "Image Gloss" ) );
    glossMethod->insertItem( tr( "Metal Foil" ) );
    glossMethod->setGeometry( QRect( 110, 30, 110, 22 ) ); 
    QToolTip::add(  glossMethod, tr( "Select specular properties. Photo gloss uses realistic OpenGL 1.2 GL_SEPARATE_SPECULAR_COLOR" ) );

    lightDirection = new QComboBox( FALSE, tab, "lightDirection" );
    lightDirection->insertItem( tr( "Spotlight" ) );
    lightDirection->insertItem( tr( "Directional Light" ) );
    lightDirection->setGeometry( QRect( 0, 30, 110, 22 ) ); 
    QToolTip::add(  lightDirection, tr( "Choose between parallel and conic light variants" ) );

    lightMethod = new QComboBox( FALSE, tab, "lightMethod" );
    lightMethod->insertItem( tr( "Normal Lighting Only" ) );
    lightMethod->insertItem( tr( "Normal Lighting + Shadow Map" ) );
    lightMethod->setGeometry( QRect( 0, 0, 220, 22 ) ); 
    lightMethod->setProperty( "currentItem", 0 );
    QToolTip::add(  lightMethod, tr( "Choose shadow generation technique. Shadow Maps require SGIX_shadow extensions." ) );

    lightView = new QCheckBox( tab, "lightView" );
    lightView->setProperty( "enabled", QVariant( FALSE, 0 ) );
    lightView->setGeometry( QRect( 90, 270, 110, 20 ) ); 
    lightView->setProperty( "text", tr( "Light/Depth View" ) );
    lightView->setProperty( "checked", QVariant( FALSE, 0 ) );
    QToolTip::add(  lightView, tr( "Visualize surface normals." ) );

    positionX = new QLabel( tab, "positionX" );
    positionX->setGeometry( QRect( 10, 160, 90, 20 ) ); 
    positionX->setProperty( "text", tr( "x-label" ) );

    directionLabel = new QLabel( tab, "directionLabel" );
    directionLabel->setGeometry( QRect( 120, 140, 90, 20 ) ); 
    directionLabel->setProperty( "text", tr( "Light Destination" ) );
    controlTabs->insertTab( tab, tr( "Light" ) );

    tab_2 = new QWidget( controlTabs, "tab_2" );

    TextLabel4 = new QLabel( tab_2, "TextLabel4" );
    TextLabel4->setGeometry( QRect( 0, 30, 53, 20 ) ); 
    TextLabel4->setProperty( "text", tr( "Amplitude" ) );
    TextLabel4->setProperty( "alignment", int( QLabel::AlignCenter ) );

    TextLabel4_2_2 = new QLabel( tab_2, "TextLabel4_2_2" );
    TextLabel4_2_2->setGeometry( QRect( 110, 30, 60, 20 ) ); 
    TextLabel4_2_2->setProperty( "text", tr( "Falloff" ) );
    TextLabel4_2_2->setProperty( "alignment", int( QLabel::AlignCenter ) );

    TextLabel4_2_3 = new QLabel( tab_2, "TextLabel4_2_3" );
    TextLabel4_2_3->setGeometry( QRect( 180, 30, 40, 20 ) ); 
    TextLabel4_2_3->setProperty( "text", tr( "Filter" ) );
    TextLabel4_2_3->setProperty( "alignment", int( QLabel::AlignCenter ) );

    TextLabel4_2_3_2_3 = new QLabel( tab_2, "TextLabel4_2_3_2_3" );
    TextLabel4_2_3_2_3->setGeometry( QRect( 180, 240, 40, 20 ) ); 
    TextLabel4_2_3_2_3->setProperty( "text", tr( "None" ) );
    TextLabel4_2_3_2_3->setProperty( "alignment", int( QLabel::AlignCenter ) );

    TextLabel4_2_3_2_2_2 = new QLabel( tab_2, "TextLabel4_2_3_2_2_2" );
    TextLabel4_2_3_2_2_2->setGeometry( QRect( 120, 240, 40, 20 ) ); 
    TextLabel4_2_3_2_2_2->setProperty( "text", tr( "None" ) );
    TextLabel4_2_3_2_2_2->setProperty( "alignment", int( QLabel::AlignCenter ) );

    TextLabel4_2 = new QLabel( tab_2, "TextLabel4_2" );
    TextLabel4_2->setGeometry( QRect( 50, 30, 60, 20 ) ); 
    TextLabel4_2->setProperty( "text", tr( "Coarseness" ) );
    TextLabel4_2->setProperty( "alignment", int( QLabel::AlignCenter ) );

    TextLabel4_2_3_2 = new QLabel( tab_2, "TextLabel4_2_3_2" );
    TextLabel4_2_3_2->setGeometry( QRect( 0, 240, 40, 20 ) ); 
    TextLabel4_2_3_2->setProperty( "text", tr( "None" ) );
    TextLabel4_2_3_2->setProperty( "alignment", int( QLabel::AlignCenter ) );

    TextLabel4_2_3_2_2 = new QLabel( tab_2, "TextLabel4_2_3_2_2" );
    TextLabel4_2_3_2_2->setGeometry( QRect( 60, 240, 40, 20 ) ); 
    TextLabel4_2_3_2_2->setProperty( "text", tr( "None" ) );
    TextLabel4_2_3_2_2->setProperty( "alignment", int( QLabel::AlignCenter ) );

    amplitudeSlider = new QSlider( tab_2, "amplitudeSlider" );
    amplitudeSlider->setProperty( "enabled", QVariant( TRUE, 0 ) );
    amplitudeSlider->setGeometry( QRect( 0, 50, 40, 190 ) ); 
    amplitudeSlider->setProperty( "maxValue", 200 );
    amplitudeSlider->setProperty( "value", 100 );
    amplitudeSlider->setProperty( "orientation", (int)QSlider::Vertical );
    QToolTip::add(  amplitudeSlider, tr( "General amplitude of terrain base frequency." ) );

    frequencySlider = new QSlider( tab_2, "frequencySlider" );
    frequencySlider->setGeometry( QRect( 60, 50, 40, 190 ) ); 
    frequencySlider->setProperty( "maxValue", 200 );
    frequencySlider->setProperty( "value", 100 );
    frequencySlider->setProperty( "orientation", (int)QSlider::Vertical );
    QToolTip::add(  frequencySlider, tr( "Terrain frequency spectrum, coarseness of terrain." ) );

    falloffSlider = new QSlider( tab_2, "falloffSlider" );
    falloffSlider->setGeometry( QRect( 120, 50, 40, 190 ) ); 
    falloffSlider->setProperty( "maxValue", 200 );
    falloffSlider->setProperty( "value", 100 );
    falloffSlider->setProperty( "orientation", (int)QSlider::Vertical );
    QToolTip::add(  falloffSlider, tr( "Amplitude falloff per iteration." ) );

    filterSlider = new QSlider( tab_2, "filterSlider" );
    filterSlider->setGeometry( QRect( 180, 50, 40, 190 ) ); 
    filterSlider->setProperty( "maxValue", 200 );
    filterSlider->setProperty( "value", 100 );
    filterSlider->setProperty( "orientation", (int)QSlider::Vertical );
    QToolTip::add(  filterSlider, tr( "Post synthesis Finite Impulse Response digital filter." ) );

    terrainMethod = new QComboBox( FALSE, tab_2, "terrainMethod" );
    terrainMethod->insertItem( tr( "Even Plane" ) );
    terrainMethod->insertItem( tr( "Fault Formation" ) );
    terrainMethod->insertItem( tr( "Midpoint Displacement" ) );
    terrainMethod->setGeometry( QRect( 0, 0, 220, 22 ) ); 
    QToolTip::add(  terrainMethod, tr( "Selects surface generation method." ) );

    randomButton = new QPushButton( tab_2, "randomButton" );
    randomButton->setGeometry( QRect( 1, 260, 222, 26 ) ); 
    randomButton->setProperty( "text", tr( "Randomize" ) );
    QToolTip::add(  randomButton, tr( "Re-seed the random number generator, creating a new terrain permutation." ) );
    controlTabs->insertTab( tab_2, tr( "Surface" ) );

    tab_3 = new QWidget( controlTabs, "tab_3" );

    TextLabel1 = new QLabel( tab_3, "TextLabel1" );
    TextLabel1->setGeometry( QRect( 0, 0, 220, 300 ) ); 
    TextLabel1->setProperty( "text", tr( QString::fromUtf8( "OpenGL 1.2 based Shadow Simulator\n(-unfinished-)\nby Moritz Voß in 2k+2\n\nThis program demonstrates, though \nnot without errors and artifacts, how \none can utilize the SGIX_shadow\nextension available on consumer \ngrade hardware and professional\nboards alike. It also provides a brief\nintroduction to fractal terrain syn-\nthesis and OpenGL lighting models.\n\nThe implementation of this software\nis flawed. Apart from some depth-buffer\nartifact problems I was unable to resolve,\nthe lighting calculations result in some\nblenging colours which I didn't intend\nto result from them.\n\nApart from that, it's a fun little piece\nof not-too-shabby code =^-.-^=" ) ) );
    controlTabs->insertTab( tab_3, tr( "About" ) );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
shadowControls::~shadowControls()
{
    // no need to delete child widgets, Qt does it all for us
}


