
//** @file MString.h
// ======================================================================== //
//  
//	 @brief A collection of string utility functions                                                                     
//                         String NX錾t@C                        //
//                                                                          //
//                               NX String                              //
//                                                                          //
//                                                                          //
//                           ėp 񑀍NX                          //
//                                                                          //
//                                                                          //
//                                                                          //
//  ֘At@C :                                                          //
//    "MString.H" : NX̐錾yуCC֐`ĩt@Cj      //
//                AvP[V CN[hpt@C                   //
//    "MString.cpp"     : ̑̊֐`                                  //
//                                                                          //
//  RXgN^ :                                                        //
//    String() : kŏ                                           //
//    String(int n) : n ̃Xy[Xŏ                            //
//    String(char *c) :  c ŏ                                   //
//    String(char *c, int n) :  c ŏA͋I n      //
//        ]ꍇ́AXy[XŖ܂                                    //
//    String(String s, int n) : String IuWFNggȊO͏Ɠ     //
//    String(String s) : String IuWFNgRs[                          //
//                                                                          //
//                                                                          //
//  st  String NX̃IuWFNgƂiString st ; j                 //
//                                                                          //
//  \bh :                                                              //
//    int st.Length() : 񒷂Ԃ                                      //
//    String& st.Length(n) : 񒷂Zbgi]ꍇ̓Xy[Xj       //
//                                                                          //
//    st = String, st = (char*) ő                                      //
//                                                                          //
//    ȍ~̃\bhŁA                                                    //
//    Mid(), Left(), Right() ́A߂ė]͋l߂ĒZȂ     //
//    RXgN^ƈႢAst ̒  n ɂȂƂ͌Ȃ           //
//                                                                          //
//    st.Mid(int m, n) : st Am ڂ n ̕ɕω         //
//    Mid(st, int m, n) : st ́Am ڂ n o            //
//                                                                          //
//    st.Left(int n) : st A n ̕ɕω                 //
//        Length(n) Ƃ̈Ⴂ́Ast ͂ݏo̓Jbg邱     //
//        Length(n) ł ͕K n ɁA͂ݏo̓Xy[XŖ܂  //
//    Left(st, n) : st ́A n o                        //
//                                                                          //
//    st.Right(int n) : st AE n ̕ɕω                //
//    Right(st, n) : st ́AE n o                       //
//                                                                          //
//                                                                          //
//  rZq :                                                            //
//    ==, !=, <, >, <=, <= : ̔r                                   //
//        ́A String ܂́AString  char*               //
//                                                                          //
//  o̓Iy[^ :                                                      //
//    <<, >>                                                                //
//                                                                          //
//                                                                          //
// ======================================================================== //*/

#ifndef ___STRING_H___
#define ___STRING_H___

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>

#include "Define.H"


//#define STRING_DEBUG

// SoCgŎ܂ 10 ׂ̂̍őliIntToString() Ŏgpj
#define MAX_DIV_DEF   1000000000

/** @class String
 *
 * @ingroup ShadowCasterClasses
 *
 * @brief Various string utility functions
 *
 */

class String
{
	enum
	{
		MIN_ALLOC_UNIT = 64,
		MAX_ALLOC_UNIT = 4096,
		MAX_LINE_BUF   = 16384,
	} ;

    int     length ;
	int     allocated ;
    char    *str ;

	// ̃NAp
    inline String& Clear()
	{
		if (str) delete [] str ;
		length = 0 ;
		str = new char[1] ;
		str[0] = '\0' ;
		allocated = 1 ;
		return *this ;
	}

	// n 쐬AۂɊmۂׂ
	// n ͖ړI̕
	inline static int ShouldAlloc(int n)
	{
		if (n < MIN_ALLOC_UNIT)
			return MIN_ALLOC_UNIT ;
		else
		{
			if ((n + 1) * 2 > MAX_ALLOC_UNIT)
				return n + 1 + MAX_ALLOC_UNIT ;
			else
				return (n + 1) * 2 ;
		}
	}

	// Ċ蓖
	// obt@Ȃꍇ
	//   mۂăRs[
	//
	// ɑĂꍇ
	//   Kvʂ̔{ȏ゠ꍇ
	//   Kvʂ̔{܂ō
	//   f[^ length \̂Œ
	//
	// n ́AKvȕ
	// ̃R[镶
	//
	// guarantee  FALSE w肳Ăꍇ
	// f[^̃Rs[͎sȂ
	inline void Realloc(int n, int guarantee = TRUE)
	{
#ifdef STRING_DEBUG
		cout << "String::Realloc(" << n << ", " << guarantee << ")" << endl ;
#endif
		if (n == length) return ;

		if (n + 1 > allocated)
		{
			// Kvʂ̔{mۂ
			// Kvʂ̔{ MAX_ALLOC_UNIT 𒴂ꍇ
			// Kvʁ{MAX_ALLOC_UNIT mۂ
			allocated = ShouldAlloc(n) ;
//			if ((n + 1) * 2 > MAX_ALLOC_UNIT)
//				allocated = n + 1 + MAX_ALLOC_UNIT ;
//			else
//				allocated = (n + 1) * 2 ;

			char *w = new char[allocated] ;

			if (guarantee)
			{
				// f[^i܂蕶񒷁{Pj
				// length + 1 oCgRs[
				//  length  n 葽ꍇ n ŗǂ
				if (length > n)
				{
					memcpy(w, str, n) ;
					w[n] = '\0' ;
				}
				else
					memcpy(w, str, length + 1) ;
			}

			// ŌɃobt@
			delete [] str ;
			str = w ;
		}
		else
		{
			// obt@܂ꍇ
			// ۂ̕Kvʂ̔{𒴂Ăꍇ
			// Kvʂ̔{AŒł MIN_ALLOC_UNIT Ƀobt@
			// f[^ length \̂Œ
			if ((n + 1) * 2 < allocated)
			{
				// Kvʂ̔{܂Ńf[^
				// Kvʂ̔{ MAX_ALLOC_UNIT 𒴂ꍇ
				// Kvʁ{MAX_ALLOC_UNIT mۂ
				if ((n + 1) * 2 > MAX_ALLOC_UNIT)
					allocated = n + 1 + MAX_ALLOC_UNIT ;
				else if ((n + 1) * 2 < MIN_ALLOC_UNIT)
					allocated = MIN_ALLOC_UNIT ;
				else
					allocated = (n + 1) * 2 ;

				char *w = new char[allocated] ;

				if (guarantee)
				{
					// ̌KvɂȂf[^inj
					// Ȃ킿 n oCgRs[
					// Amۗʂ n + 1 ɑȂꍇ
					// 镔܂łRs[
					//
					// n ̍Ōɂ̓kǉ
					if (n + 1 > allocated)
					{
						memcpy(w, str, allocated - 1) ;
						w[allocated - 1] = '\0' ;
					}
					else
					{
						memcpy(w, str, n) ;
						w[n] = '\0' ;
					}
				}

				// ŌɃobt@
				delete [] str ;
				str = w ;
			}
		}
	}

	// f[^̃Rs[
	// Rs[ɍĊmۂĂf[^Rs[
	inline void Copy(const String& s)
	{
		if (this == &s) return ;

		// Kvȏꍇ͍Ċm
		// ȂƂRs[ s.length ̃f[^͕ۏ؂
		// f[^̃Rs[͕KvȂ̂ FALSE n
		Realloc(s.length, FALSE) ;

		// ۂ̃f[^Rs[
		length = s.length ;
		memcpy(str, s.str, s.length) ;

		// Ō͈ꉞIɃkǉ
		str[length] = '\0' ;
	}

	String& ReadAllLines(FILE *fp) ;

  public:

    // RXgN^
    String()
	{
		str = NULL ;
		Clear() ;
	}

    String(int n) ;
//    String(char *c, int n = -1) ;
    String(const char *c) ;
    String(const char *c, int n) ;// = -1) ;
    String(const String &s) ;
    String(const String &s, int) ;// n = -1) ;
    String(char c) ;

    // fXgN^
    ~String() { if (str) delete [] str ; }

    // LXgZqichar*j
//#ifdef WIN32
	inline operator char*() const { return str ; }
//#else
//	const operator char*() const { return str ; }
//#endif

    // ANZT
    inline int Length() const { return length ; }

    // ̒ωi]̓Xy[X ' 'j
    String& Length(int n) ;

    // n ڂ̂P
    char Character(int n = 1) const ;

	// n ڂ̕ύX
	String& SetAt(int n, char c) ;

	String& ReplaceString(char s, char d) ;
	String& ReplaceString(const String& s, const String& d) ;
	inline String& ReplaceString(const String& s, char d) { ReplaceString(s, String(d)) ; return *this ; }
	inline String& ReplaceString(const char s, const String& d) { ReplaceString(String(s), d) ; return *this ; }

	// Lower, Upper
	String& Lower() ;
	inline friend String Lower(const String& s) { String w = s ; w.Lower() ; return w ; }
	String& Upper() ;
	inline friend String Upper(const String& s) { String w = s ; w.Upper() ; return w ; }

	// tH[}bg
	String& Format(const char* format, ...) ;

	// tH[}bgǉ
	String& AddFormat(const char* format, ...) ;

	// eLXgt@Cǂݍ
	String& ReadFile(const String& fileName) ;

	// g[N
	// Ԃꂽg[Niŏ̕j͍폜
	// String("") Ԃ܂ŌJԂ

#define __STRING_DEFAULT_TOKEN_DELIMITERS	" \t\n"
#define __STRING_DEFAULT_TOKEN_COMMENT		"//"

//#ifdef macintosh
	// for Mac
	String Token(const String &delimiters , const String& comment) ;
	inline String Token(const String &delimiters) { return Token(delimiters, String(__STRING_DEFAULT_TOKEN_COMMENT)) ; }
	inline String Token() { return Token(String(__STRING_DEFAULT_TOKEN_DELIMITERS), String(__STRING_DEFAULT_TOKEN_COMMENT)) ; }

//#else	// #ifdef macintosh
//	String Token(const String& delimiters = String(__STRING_DEFAULT_TOKEN_DELIMITERS),
//				 const String& comment = String(__STRING_DEFAULT_TOKEN_COMMENT)) ;
//
//#endif	// #ifdef macintosh ... #else

    // m ڂ n 
    String& Mid(int m, int n = 1) ;
    friend String Mid(String s, int m, int n = 1) ;

    //  n 
    String& Left(int n = 1) ;
    friend String Left(const String& s, int n = 1) ;

    // E n 
    String& Right(int n = 1) ;
    friend String Right(const String& s, int n = 1) ;

	String FileDirectory() const ;
	String FileNamePart() const ;

    // T[`iŏɈvꏊԂj
    int Search(const String& key, int start = 0) const ;
    int Search(const char   *key, int start = 0) const ;
    int Search(const char    key, int start = 0) const ;

/*
    // T[`iŏɈvꏊԂj
    int Search(const String& key) const ;
    int Search(const char   *key) const ;
    int Search(const char    key) const ;
*/

    // Iy[^i/j܂́A̕T[`Av񐔂Ԃ
    int operator /(const String& key) const ;
    int operator /(const char   *key) const ;
    int operator /(const char    key) const ;

    // Iy[^i=jZq
    String& operator =(const String& s) ;
    String& operator =(const char   *c) ;
    String& operator =(const char    c) ;

    // riŏ n  s ƓŁAn オ s Ɠr؂j
    // R}hIvṼT[`ȂǂŎgp
    int Equ(const String s, int n = 1) ;

    // n 召ristrncmp()ƓAn ȗƁAstrcmp() Ɠj
    int Cmp(const String s, int n = -1) ;

    // Iy[^i==, !=jrZq
    int operator ==(const String& s2) const ;
    int operator !=(const String& s2) const ;
    int operator ==(const char    *c) const ;
    int operator !=(const char    *c) const ;
    int operator ==(const char     c) const ;
    int operator !=(const char     c) const ;
    friend int operator ==(const char *c, const String& s2) ;
    friend int operator !=(const char *c, const String& s2) ;
    friend int operator ==(const char  c, const String& s2) ;
    friend int operator !=(const char  c, const String& s2) ;

    // Iy[^i>, <, >=, <=jrZq
    int operator > (const String& s2) const ;
    int operator < (const String& s2) const ;
    int operator >=(const String& s2) const ;
    int operator <=(const String& s2) const ;
    int operator > (const char    *c) const ;
    int operator < (const char    *c) const ;
    int operator >=(const char    *c) const ;
    int operator <=(const char    *c) const ;
    int operator > (const char     c) const ;
    int operator < (const char     c) const ;
    int operator >=(const char     c) const ;
    int operator <=(const char     c) const ;
    friend int operator > (const char *c, const String& s2) ;
    friend int operator < (const char *c, const String& s2) ;
    friend int operator >=(const char *c, const String& s2) ;
    friend int operator <=(const char *c, const String& s2) ;
    friend int operator > (const char  c, const String& s2) ;
    friend int operator < (const char  c, const String& s2) ;
    friend int operator >=(const char  c, const String& s2) ;
    friend int operator <=(const char  c, const String& s2) ;

    // Iy[^i()jZq
    String& operator ()(const String& s) ;
    String& operator ()(const char   *c) ;
    String& operator ()(const char    c) ;

    // Iy[^i+, +=j
    String operator +(const String& s) const ;
    String operator +(const char   *s) const ;
    String operator +(const char    c) const ;
    friend String operator +(const char *d, const String& s) ;
    friend String operator +(const char  d, const String& s) ;
    String& operator +=(const String& s) ;
    String& operator +=(const char   *s) ;
    String& operator +=(const char    c) ;

    // Iy[^i*, *=j
    String operator *(int n) ;
    String& operator *=(int n) ;

    // o̓Iy[^
    friend ostream& operator <<(ostream& os, const String& s) ;
    friend istream& operator >>(istream& is, String& s) ;


    // g

    // ̐؂l߁iE󔒂܂͉s܂TABȂj
    String& Cut() ;
    friend String& Cut(String      s) ;
    friend String& Cut(const char *s) ;
} ;

//  String 
String IntToString(int i) ;


#ifdef OVERRIDE_NEW_OPERATOR
void MemDebugFinal() ;
#endif	// #ifdef OVERRIDE_NEW_OPERATOR


#endif

