
/** @file mainapp.cpp
 *
 *  @ingroup appclasses
 *  
 *  Here goes all the global init code/main() code for the application.  A few
 *  things here, possibly including some odds and ends...
 */

// system library headers
#include <stdlib.h>
#include <stdio.h>

// Qt headers
#include <qapplication.h>
#include <qpixmap.h>
#include <qmotifstyle.h>

#include "GLFramework.h"
#include "icons.h"

// initializes and starts the main application window
int main(int argc, char** argv)
{
	// the application object, also responsible for the main message loop
	QApplication* mainapp = new QApplication(argc, argv);
	
	// main window widget
	GLFramework* gui = new GLFramework(0, "gui");
	CHECK_PTR(gui);
	
	// this sets the icon in the upper-left corner of the window
	QPixmap picon((const char**)(PROGRAM_ICON));
	gui->setIcon(picon);
		
	// set caption for the main window
	gui->setCaption("OpenGL image processing framework");
	
	// this can be used to preview the app's UNIX look while still 
	// in Windows set to 1 to enable

	#if 0
	QMotifStyle* style = new QMotifStyle();
	mainapp->setStyle(style);
	#endif

	mainapp->setMainWidget(gui);
	
	// show the primary window and displace it a bit to the right-bottom
	gui->show();
	gui->setGeometry(50,50,800,600);
	
	return mainapp->exec();

}

