
/**
 * @file icons.h
 *
 * @ingroup appclasses 
 *
 * This file contains all icons used in the primary application in XPM form
 *
 * 
 *
 **/

#ifndef ICONS_H
#define ICONS_H

/** @hideinitializer */
static const char* const OPEN_ICON[] = 
{
	"16 13 5 1",
	". c #040404",
	"# c #808304",
	"a c None",
	"b c #f3f704",
	"c c #f3f7f3",
	"aaaaaaaaa...aaaa",
	"aaaaaaaa.aaa.a.a",
	"aaaaaaaaaaaaa..a",
	"a...aaaaaaaa...a",
	".bcb.......aaaaa",
	".cbcbcbcbc.aaaaa",
	".bcbcbcbcb.aaaaa",
	".cbcb...........",
	".bcb.#########.a",
	".cb.#########.aa",
	".b.#########.aaa",
	"..#########.aaaa",
	"...........aaaaa"
};

/** @hideinitializer */
static const char* const SAVE_ICON[] = {
"16 16 3 1",
" 	c Black",
".	c None",
"X	c #000080",
" .. ............",
". . ............",
"..  ............",
"   X............",
".......XXXXXXXXX",
"......XX....XXXX",
".....XXX....XXXX",
"....XXXXXXXXXXXX",
"....XXXXXXXXXXXX",
"....XXXXX..XXXXX",
"....XXXXX..XXXXX",
"....XXXXXXXXXXXX",
"....XXXXXXXXXXXX",
"....XXXXXXXXXXXX",
"....XXXXXXXXXXXX",
"....XXXXXXXXXXXX"};

/** @hideinitializer */
static const char* const RESET_ICON[] = {
"16 16 2 1",
" 	c None",
".	c Red",
" ..         ..  ",
".....      .... ",
"......     .... ",
" ......   ..... ",
"  ...... ...... ",
"   ...........  ",
"    .........   ",
"     .......    ",
"     .......    ",
"    .........   ",
"   ...........  ",
"  ...... ...... ",
" ......   ......",
"......     .....",
".....       ... ",
" ..             "};


/** @hideinitializer */
static const char* const PLAY_ICON[]=
{
	"16 16 3 1",
	". c None",
	"a c #00CC00",
	"b c #000000",
	"................",
	"b...............",
	"bbb.............",
	"baabb...........",
	"baaaabb.........",
	"baaaaaabb.......",
	"baaaaaaaabb.....",
	"baaaaaaaaaabb...",
	"baaaaaaaaaabb...",
	"baaaaaaaabb.....",
	"baaaaaabb.......",
	"baaaabb.........",
	"baabb...........",
	"bbb.............",
	"b...............",
	"................",
};

/** @hideinitializer */
static const char* const QUIT_ICON[] = 
{
	"15 15 2 1",
	"	c Black",
	".	c #FFFF00",
	"               ",
	"      ...      ",
	"    .......    ",
	"   ..  .  ..   ",
	"   ..  .  ..   ",
	" .  .......  . ",
	" ...  ...  ... ",
	"    . ... .    ",
	"     .....     ",
	"       .       ",
	"     .. ..     ",
	"    .     .    ",
	" ...       ... ",
	" ..         .. ",
	"               " 
};

/** @hideinitializer */
static const char* const PROGRAM_ICON[] = 
{
	"16 16 2 1",
	" 	c #000084",
	".	c Cyan",
	"                ",
	"                ",
	"  ..  .    .... ",
	"  .   .    .    ",
	" .    .    .    ",
	" .    .    .    ",
	" . .. .    .... ",
	" .  . .    .    ",
	" .  . .    .    ",
	" .  . .    .    ",
	" .  . .    .    ",
	" .  . .    .    ",
	"  . . .    .    ",
	"  ... .... .    ",
	"                ",
	"                "

};

/** @hideinitializer */
static const char* const STOP_ICON[] = 
{
	"15 15 2 1",
	" 	c #000000",
	".	c #0000AA",

	"               ",
	" ............. ",
	" ............. ",
	" ............. ",
	" ............. ",
	" ............. ",
	" ............. ",
	" ............. ",
	" ............. ",
	" ............. ",
	" ............. ",
	" ............. ",
	" ............. ",
	" ............. ",
	"               "

};

/** @hideinitializer */
static const char* const PAUSE_ICON[] = 
{
	"15 15 3 1",
	" 	c #000000",
	".	c #F0F0F0",
	"|  c None",

	"      |||      ",
	" .... ||| .... ",
	" .... ||| .... ",
	" .... ||| .... ",
	" .... ||| .... ",
	" .... ||| .... ",
	" .... ||| .... ",
	" .... ||| .... ",
	" .... ||| .... ",
	" .... ||| .... ",
	" .... ||| .... ",
	" .... ||| .... ",
	" .... ||| .... ",
	" .... ||| .... ",
	"      |||      "

};

/** @hideinitializer */
static const char* const ARROW_UP[] =
{ 
"9 9 3 1",
" 	c None",
".	c Black",
"X	c Green",
"    .    ",
"   .X.   ",
"   .X.   ",
"  .XXX.  ",
"  .XXX.  ",
" .XXXXX. ",
" .XXXXX. ",
".XXXXXXX.",
"........."};

/** @hideinitializer */
static const char* const ARROW_DOWN[] = 
{

"9 9 3 1",
" 	c Black",
".	c Red",
"X	c None",
"         ",
" ....... ",
"X ..... X",
"X ..... X",
"XX ... XX",
"XX ... XX",
"XXX . XXX",
"XXX . XXX",
"XXXX XXXX"};

/** @hideinitializer */
static const char* const TRACKBALL_CURSOR_SMALL[] = {
"21 21 2 1",
" 	c None",
".	c Black",
"          .          ",
"         ...         ",
"         ...         ",
"        .....        ",
"        .....        ",
"       .......       ",
"                     ",
"     .         .     ",
"   ...         ...   ",
" .....   . .   ..... ",
"......    .    ......",
" .....   . .   ..... ",
"   ...         ...   ",
"     .         .     ",
"                     ",
"       .......       ",
"        .....        ",
"        .....        ",
"         ...         ",
"         ...         ",
"          .          "};

/** @hideinitializer */
static const char* const TRACKBALL_CURSOR_LARGE[] = {
"32 32 2 1",
" 	c None",
".	c White",
"               ..               ",
"              ....              ",
"              ....              ",
"             ......             ",
"             ......             ",
"            ........            ",
"            ........            ",
"           ..........           ",
"           ..........           ",
"                                ",
"                                ",
"       ..              ..       ",
"     ....              ....     ",
"   ......    .    .    ......   ",
" ........     .  .     ........ ",
".........      ..      .........",
".........      ..      .........",
" ........     .  .     ........ ",
"   ......    .    .    ......   ",
"     ....              ....     ",
"       ..              ..       ",
"                                ",
"                                ",
"           ..........           ",
"           ..........           ",
"            ........            ",
"            ........            ",
"             ......             ",
"             ......             ",
"              ....              ",
"              ....              ",
"               ..               "};

/** @hideinitializer */
static const char* const TRACKBALL_ROTATION_CURSOR[] = {

"32 32 2 1",
" 	c None",
".	c White",
"                                ",
"                                ",
"                                ",
"                                ",
"              ....              ",
"     .     ...    ...           ",
"     .   ..          ..         ",
"     .. .              .        ",
"     ...                .       ",
"     ....                .      ",
"     ......              .      ",
"                          .     ",
"                          .     ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"     .                          ",
"     .                          ",
"      .              ......     ",
"      .                ....     ",
"       .                ...     ",
"        .              . ..     ",
"         ..          ..   .     ",
"           ...    ...     .     ",
"              ....              ",
"                                ",
"                                ",
"                                ",
"                                "};

/** @hideinitializer */
static const char* const TRACKBALL_FOV_CURSOR[] =
{
	"32 32 2 1",
" 	c None",
".	c White",
"                                ",
"                                ",
"                         ..     ",
"                       ..       ",
"                    ...         ",
"                  ...           ",
"               ...  .           ",
"            ...     ..          ",
"          ..        ..          ",
"       ...         .  .         ",
"     ..            .  .         ",
"   ..              .  .         ",
"     ...           .  .         ",
"        ...        .  .         ",
"           ...      ..          ",
"              ..    ..          ",
"                ... .           ",
"                   ...          ",
"                      ...       ",
"                         ..     ",
"                                ",
"                                ",
"      ....   ...  .     .       ",
"      .     .   . .     .       ",
"      .     .   .  .   .        ",
"      ...   .   .  .   .        ",
"      .     .   .   . .         ",
"      .     .   .   . .         ",
"      .      ...     .          ",
"                                ",
"                                ",
"                                "};

/** @hideinitializer */
static const char* const TRACKBALL_ORBIT_CURSOR[] = {
"32 32 2 1",
" 	c None",
".	c White",
"                                ",
"                .               ",
"               . .              ",
"              .   .             ",
"              .   .             ",
"             .     .            ",
"             .     .            ",
"             .     .            ",
"             .     .            ",
"            .       .           ",
"            .       .           ",
"          ............          ",
"      ....  .       . ....      ",
"    ..      .       .     ..    ",
"  ..        .       .       .   ",
"  .        ...      .        .  ",
" .        .....     .         . ",
" .       .......    .         . ",
"  .         .       . .      .  ",
"  ..        .       . ..    .   ",
"    ..      .       . ... ..    ",
"      ....  .       . ....      ",
"          ...............       ",
"             .     .  ..        ",
"             .     .  .         ",
"             .     .            ",
"             .     .            ",
"              .   .             ",
"              .   .             ",
"               . .              ",
"                .               ",
"                                "};

/** @hideinitializer */
static const char* const TRACKBALL_ORBIT_HORIZONTAL[] = {
"32 32 2 1",
" 	c None",
".	c White",
"                                ",
"                .               ",
"              .. ..             ",
"              .   .             ",
"             .     .            ",
"             .     .            ",
"            .       .           ",
"            .       .           ",
"            .       .           ",
"            .       .           ",
"           .         .          ",
"           .         .          ",
"                     .          ",
"                     .          ",
"           .         .          ",
"          ...        .          ",
"         .....       .          ",
"        .......      .          ",
"       .........     .          ",
"           .         .          ",
"           .         .          ",
"           .         .          ",
"            .       .           ",
"            .       .           ",
"            .       .           ",
"            .       .           ",
"             .     .            ",
"             .     .            ",
"              .   .             ",
"              .. ..             ",
"                .               ",
"                                "};

/** @hideinitializer */
static const char* const TRACKBALL_ORBIT_VERTICAL[] = {
"32 32 2 1",
" 	c None",
".	c White",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"          ............          ",
"     .....            .....     ",
"   ..                      ..   ",
"  .                          .  ",
" .                            . ",
" .           .                . ",
"  .          ..              .  ",
"   ..        ...           ..   ",
"     .....   ....     .....     ",
"          ........  ..          ",
"             ....               ",
"             ...                ",
"             ..                 ",
"             .                  ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                "};

/** @hideinitializer */
static const char* const TRACKBALL_ICON[] = {
"48 48 5 1",
" 	c White",
".	c Black",
"X	c Red",
"o	c Blue",
"O	c Red",
"                                                ",
"                                                ",
"                                                ",
"                      ....                      ",
"                 ..... .. .....                 ",
"               ..     .  .     ..               ",
"             ..      .    .      ..             ",
"            .        .    .        .            ",
"          ..        .      .        ..          ",
"         .          .      .          .         ",
"        .           .      .           .        ",
"        .          .        .          .        ",
"       .           .        .           .       ",
"      .            .        .            .      ",
"      .            .        .            .      ",
"    ..            ..        .             .     ",
"   .X.           .oo.        .            .     ",
"  .XXX.         .oooo.       .             .    ",
" .......       ........      .    .        .    ",
"    .             .          .   ..        .    ",
"    .             .          .  .O.        .    ",
"    .         ..................OO.        .    ",
"   .    ......    .          .  .O.....     .   ",
"   . ...          .   ...    .   ..    ...  .   ",
"   ..             .  .....   .    .       . .   ",
"   .        .     .  .....   .             ..   ",
"   ..       ..    .  .....   .            . .   ",
"    ....    .O.   .   ...    .         ... .    ",
"    .   .....OO.  .          .   ......    .    ",
"    .       .OO..................          .    ",
"    .       .O.   .          .             .    ",
"    .       ..    .          .         ........ ",
"     .      .     .          .          .XXXX.  ",
"     .             .     ........        .XX.   ",
"      .            .      .oooo.         ...    ",
"      .            .       .oo.          .      ",
"       .           .        ..          .       ",
"        .          .        .          .        ",
"        .           .      .           .        ",
"         .          .      .          .         ",
"          ..        .      .        ..          ",
"            .        .    .        .            ",
"             ..      .    .      ..             ",
"               ..     .  .     ..               ",
"                 ..... .. .....                 ",
"                      ....                      ",
"                                                ",
"                                                "};

#endif


