
/*****************************************************************************\
 *                              Simple Effect
\*****************************************************************************/

/*! @file SimpleEffect.cpp
 *
 *  @brief
 *	SimpleEffect effect class implementation
 *    
 *  @author 
 *  
 *  
 */

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

// Qt headers
#include <qtimer.h>

// Local Headers
#include "SimpleEffect.h"

/*****************************************************************************\
 *                              Simple Effect
\*****************************************************************************/

// **** Construction/desctruction ****

/**
 * @param parent Pointer to the parent window.
 *  
 * @see GLEffect::GLEffect(), effectInfo
 **/

SimpleEffect::SimpleEffect(GLFramework* parent):GLEffect(parent)
{

	effectInfo->effectName = "Simple Effect";
	effectInfo->fileDialogNames[0] = "Load Image(s)";
	effectInfo->needNewTextures = true;
	effectInfo->requiredImageLists = 1;
	effectInfo->shortDescription = "Animated textured square";
	effectInfo->version = "1.0";
	effectInfo->author = "Fred";
	effectInfo->needRawTextures = false;


	
	/* This has to be included as the last line in your constructor. 
	Don't forget it! */
	createControlPanel(false);
	hideControls();

}

/**
 * 
 *
 * @see GLEffect::~GLEffect()
 **/
SimpleEffect::~SimpleEffect()
{	
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_DEPTH_TEST);

}

// Initialization
/**
 * 
 *
 * @see GLEffect::init()
 **/

void SimpleEffect::initialize()
{
	// init effect params 
	viewDistance = 3;
	nearClipPlane = 1;
	farClipPlane = 30;
	fovAngle = 60.0;

	rotationAngle = 0.0;
	angleDelta = 1.0;

	currentDepthCoord = 0.0;

	glClearColor(0.0,0.0,0.0,1);
	glShadeModel(GL_SMOOTH);

	glLoadIdentity();
	
	// set texturing parameters
	glEnable(GL_DEPTH_TEST);

	glEnable(GL_TEXTURE_2D);

	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);

	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	
	glGenTextures(1, &texture);
	glBindTexture(GL_TEXTURE_2D, texture);

	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T, GL_REPEAT);
	
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER, GL_LINEAR);

	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST); 

	//texImage1 = parentFrame->fetchNextImage(0);


}

/**
 * 
 * 
 * @see GLEffect::createControlPanel()
 **/
void SimpleEffect::createControls(QWidget* parentWindow)
{
  effectTimer = new QTimer();
  connect(effectTimer, SIGNAL(timeout()), this, SLOT(animate()) );

}

// **** Animation and Rendering Control functions ****

/**
 * 
 * Starts effect animation. 
 *
 **/

void SimpleEffect::play()
{
	effectTimer->start(50, false);
}

/**
 * 
 * Stops animation. 
 *
 **/

void SimpleEffect::stop()
{
	effectTimer->stop();
	texImage1 = parentFrame->fetchImage(0,0);

	update();

}

/**
 * 
 * Resets effect parameters. 
 *
 **/

void SimpleEffect::reset()
{
	rotationAngle = 0.0;
	texImage1 = parentFrame->fetchImage(0,0);
	effectTimer->stop();

	update();

}

/**
 * 
 * Pauses animation. 
 *
 **/

void SimpleEffect::pause()
{
	effectTimer->stop();

}

/**
 * 
 * Renders the effect. 
 *
 **/

void SimpleEffect::render()
{
	glEnable(GL_TEXTURE_2D);

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
	// hook up the current texture
	if(texImage1!=0)
	 glTexImage2D(GL_TEXTURE_2D,0,4,texImage1->width(), texImage1->height(),
				 0, GL_RGBA, GL_UNSIGNED_BYTE, texImage1->bits());
	
	glBindTexture(GL_TEXTURE_2D, texture);

	//trasform the scene
	glRotated(-rotationAngle, 1,1,-1);
	glScaled(0.5, 0.5, 0.5);

	//paint a textured square
	glBegin(GL_QUADS);
		glTexCoord2f(0,0); glVertex3f(-1,-1,0);
		glTexCoord2f(0,1); glVertex3f(-1,1,0);
		glTexCoord2f(1,1); glVertex3f(1,1,0);
		glTexCoord2f(1,0); glVertex3f(1,-1,0);
	glEnd();

	glDisable(GL_TEXTURE_2D);

}

void SimpleEffect::animate()
{
	rotationAngle += angleDelta; // change current rotation angle
	if( (rotationAngle > 360.0) | (rotationAngle < 0.0) ) 
		angleDelta *= -1; //rotate in the opposite direction 

	texImage1 = parentFrame->fetchNextImage(0);
	update();

}


