// some vector utility functions

#include <math.h>
#include "vector.h"

float vecSqrMagnitude (const VECTOR3D& v)
{
	return v.x*v.x + v.y*v.y + v.z*v.z;
}

float vecMagnitude (const VECTOR3D& v)
{
	return (float) sqrt (vecSqrMagnitude (v));
}

VECTOR3D vecNormalize (const VECTOR3D& v)
{

#if (defined (__cplusplus) | !defined (__STDC__))
	return v / vecMagnitude (v);
#else
	VECTOR3D vResult;
	float fMag = vecMagnitude (v);
	vResult.x = v.x / fMag;
	vResult.y = v.y / fMag;
	vResult.z = v.z / fMag;
	return vResult;
#endif

}

float vecDotProduct (const VECTOR3D& v1, const VECTOR3D& v2)
{
	return v1.x*v2.x + v1.y*v2.y + v1.z*v2.z;
}

VECTOR3D vecCrossProduct (const VECTOR3D& v1, const VECTOR3D& v2)
{

#if (defined (__cplusplus) | !defined (__STDC__))	
	return VECTOR3D (v1.y*v2.z - v1.z*v2.y,
					 v1.z*v2.x - v1.x*v2.z,
					 v1.x*v2.y - v1.y*v2.x);
#else
	VECTOR3D vResult;
	vResult.x = v1.y*v2.z - v1.z*v2.y;
	vResult.y = v1.z*v2.x - v1.x*v2.z;
	vResult.z = v1.x*v2.y - v1.y*v2.z;
	return vResult;
#endif
}

