//#include<iostream.h>
#include<math.h>
#include<assert.h>
#include"vector.h"
#include"geomObj.h"


// Initialisierung mit Hilfe der default-Vektoren:
Edge::Edge():point1(0,0,0),point2(0,0,0){type = edge;}
//Copy constructor.
Edge::Edge(const Edge &original):point1(original.point1),point2(original.point2)
								{type = original.type;}
Edge::Edge(VECTOR3D p1, VECTOR3D p2,EDGE t):point1(p1),point2(p2){type = t;}

Edge & Edge::operator=(const Edge &orig){
   point1=orig.point1;
   point2=orig.point2;
   type=orig.type;
   return *this;
}

int Edge::operator==(Edge &other){
   if(point1!=other.point1) return 0;
   if(point2!=other.point2) return 0;
   if(type!=other.type) return 0;
   return 1;
}


VECTOR3D projection (Edge projEdge, VECTOR3D x)
{
	// the direction vector of the edge
	VECTOR3D a = projEdge.point2 - projEdge.point1;
	// parameter in the line equation
	// t = <(x-p),a>/||a||^2
	// if t is between 0 and 1, the projection point is between point1 and point2
	float t = vecDotProduct (x-projEdge.point1, a)/vecSqrMagnitude(a);
	switch (projEdge.type)
	{
		case edge:
			// cut t to 1 if its greater
			t = (t > 1 ? 1 : t);
		// fall through
		case ray:
			// cut t to 0 if its less
			t = (t < 0 ? 0 : t);
	}

	return projEdge.point1 + t*a ;
}


int IntersectEdgeParallelogram (Edge sectEdge, Edge firstParEdge, Edge secParEdge,
											VECTOR3D *pIntersection)
{
	// some inititialisations:
	// the normal vector of the plane in wich the parallelogram lies:
	VECTOR3D vPlaneNormal = vecNormalize (
							vecCrossProduct (firstParEdge.point2-firstParEdge.point1,
											secParEdge.point2-secParEdge.point1));
	// the direction vector r of the line
	VECTOR3D vDirection = sectEdge.point2 - sectEdge.point1;


	// first, calculate the parameter in the line equation for the intersection point
	// t = <(a - b),n>/<r,n>
	// where a is an arbitrary point on the plane
	// b is an arbitrary point on the line
	// n is the normal vector of the plane
	// r is the direction vector of the line
	// if <r,n>=0, the plane is parallel to the line, so there is no intersection
	float r_dot_n = vecDotProduct (vDirection,vPlaneNormal);
	if (fabs (r_dot_n) < 1e-6)
		return 0;
	float t = vecDotProduct (firstParEdge.point1-sectEdge.point1,vPlaneNormal)/r_dot_n;

	// if the edge hasn't infinite length check the range of t
	switch (sectEdge.type)
	{
		case edge :
			if (t < 0) return 0;
		// fall through
		case ray:
			if (t > 1) return 0;
	}

	// set the parameter in the line equation
	VECTOR3D vIntersect = sectEdge.point1 + t*vDirection;

	if (firstParEdge.type != line || secParEdge.type != line)
	{

		// check if the intersection point is in the parallelogram:
		// first project it on its edges
		VECTOR3D vfirstProjection = projection (firstParEdge, vIntersect);
		VECTOR3D vsecProjection = projection (secParEdge, vIntersect);

		// ok, if the intersection point isn't inside the parallelogram
		// project it on the bounds
		// the new point has coords:
		// vIntersect = firstParEdge.point1 +
		//				vfirstProjection - firstParEdge.point1
		//				vsecProjection   - firstParEdge.point1
		vIntersect = vfirstProjection + vsecProjection - firstParEdge.point1;

	}

	*pIntersection = vIntersect;
	return 1;
}


VECTOR3D atrans(VECTOR3D point, const float* matrix){
   //calculate x,y,z,t
   float x = point.x*matrix[0]+point.y*matrix[1]+point.z*matrix[2]+matrix[3];
   float y = point.x*matrix[4]+point.y*matrix[5]+point.z*matrix[6]+matrix[7];
   float z = point.x*matrix[8]+point.y*matrix[9]+point.z*matrix[10]+matrix[11];
   float t = point.x*matrix[12]+point.y*matrix[13]+point.z*matrix[14]+matrix[15];
   //normalize t
   assert(t!=0);
   if (fabs(t) > 1e-5)
   {
	   x /= t;
	   y /= t;
	   z /= t;
   }
   return VECTOR3D(x,y,z);
}


