/*
 * Copyleft 2001 Lukas Degener, Ingmar Kanitscheider. All rights granted ;-)
 *----------------------
 * file: src/Pixmaps.h
 *----------------------
 * This file is part of the CountourWarp Effect based on the GLEffect Framework.
 * 
 */

/** @file Icon.h
 *
 *  @ingroup contourWarpClasses
 *
 *  @brief XPM icon data for effect control buttons etc.
 *
 */


#ifndef ICON_H
#define ICON_H

#include <qpixmap.h>

//Just a few defines for pixmaps

/* XPM icon data for effect control buttons etc. */


//! @hideinitializer
static const char* const line_xpm[] = {

"22 22 2 1",
". c #000000",
"# c None",

"######################",
"#################.####",
"#################.####",
"###############.....##",
"################..####",
"###############.#.####",
"##############.#######",
"#############.########",
"############.#########",
"###########.##########",
"##########.###########",
"#########.############",
"########.#############",
"#######.##############",
"######.###############",
"###.#.################",
"###..#################",
"#.....################",
"###.##################",
"###.##################",
"######################",
"######################"};

//! @hideinitializer
static const char* const translate_xpm[] = {
"22 22 3 1",
" 	c Black",
".	c #808080",
"X	c Cyan",
"                      ",
"                      ",
"                      ",
"                      ",
"                      ",
"                  ... ",
"                ..    ",
"               .      ",
"              .       ",
"         XXX .        ",
"         XXX .        ",
"         XXX .        ",
"             .        ",
"         .....        ",
"        .             ",
"       .              ",
"     ..               ",
"  ...                 ",
"                      ",
"                      ",
"                      ",
"                      "};

//! @hideinitializer
static const char* const scale_xpm[] = {
"22 22 3 1",
" 	c Black",
".	c #a0a0a4",
"X	c gainsboro",
"                      ",
"                      ",
"                      ",
"                      ",
"    ..... . . .       ",
"    ..... XXXXX.      ",
"    ..XXXX            ",
"    ..XXX.XXXXX.XXX . ",
"      X...XXXXX XXX . ",
"    .X XXXXXXXX.XXX . ",
"     X XXXXXXXX.XXX . ",
"    .X XXXXXXX XXXX . ",
"     . . . . .X X X . ",
"       XXXXXXXXX  X . ",
"       XXXXXXXX   X . ",
"       XXXXXXXXXXXX . ",
"                    . ",
"       .............. ",
"                      ",
"                      ",
"                      ",
"                      "};

//! @hideinitializer
static const char* const rotate_xpm[] = {
"20 20 2 1",
" 	c Black",
".	c Blue",
"                    ",
"                    ",
"                    ",
"                    ",
"        ....        ",
"       ..    .      ",
"       .         .  ",
"      ..            ",
"                  . ",
"       ..         . ",
"      ..          . ",
"     ..           . ",
"     .            . ",
"                 .. ",
"                 .  ",
"                ..  ",
"               ..   ",
"             ...    ",
"           ...      ",
"                    "};

//! @hideinitializer
static const char* const selectrect_xpm[] = {
"22 22 2 1",
" 	c Black",
".	c Red",
"                      ",
"                      ",
"  ..................  ",
"  .                .  ",
"  .                .  ",
"  .                .  ",
"  .                .  ",
"  .                .  ",
"  .                .  ",
"  .                .  ",
"  .                .  ",
"  .                .  ",
"  .                .  ",
"  .                .  ",
"  .                .  ",
"  .                .  ",
"  .                .  ",
"  .                .  ",
"  .                .  ",
"  ..................  ",
"                      ",
"                      "};

//! @hideinitializer
static const char* const selectcircle_xpm[] = {
"22 22 2 1",
" 	c Black",
".	c Green",
"                      ",
"                      ",
"         ....         ",
"      ...    ...      ",
"     .          .     ",
"    .            .    ",
"   .              .   ",
"   .              .   ",
"   .              .   ",
"  .                .  ",
"  .                .  ",
"  .                .  ",
"  .                .  ",
"   .              .   ",
"   .              .   ",
"   .              .   ",
"    .            .    ",
"     .          .     ",
"      ...    ...      ",
"         ....         ",
"                      ",
"                      "};

//! @hideinitializer
static const char* const kill_xpm[]={
"14 12 3 1",
". c #800000",
"# c #FFFFFF",
"a c None",
"..#aaaaaaaa..#",
"....#aaaaa..#a",
"a....#aaa..#aa",
"aaa...#a.#aaaa",
"aaaa.....#aaaa",
"aaaaa...#aaaaa",
"aaaa.....#aaaa",
"aaa...#a..#aaa",
"aa...#aaa..#aa",
"a...#aaaaa.#aa",
"a...#aaaaaa.#a",
"aa.#aaaaaaaa.#"};

//! @hideinitializer
static const char* const configure_xpm[] = {
"22 22 19 1",
" 	c Black",
".	c #808080",
"X	c #585858",
"o	c gainsboro",
"O	c Gray81",
"+	c Gray72",
"@	c #a0a0a0",
"#	c Gray80",
"$	c Gray100",
"%	c #d8d8d8",
"&	c Gray19",
"*	c Gray93",
"=	c Gray76",
"-	c #646464",
";	c Gray86",
":	c Gray47",
">	c #e7e7e7",
",	c #c3c3c3",
"<	c #b7b7b7",
"                      ",
"                      ",
"            .         ",
"      XXoO+@          ",
"      #+XXooO+@       ",
"       $#+XXoO+@      ",
"         $#+Xo%@ @    ",
"  $o       $&o%O@     ",
"  $*o=     &=oo%@     ",
"  -$*oo=  &=ooo%@     ",
"  o-$$*ooooooo;O@@    ",
"  oo-:$$**ooo*>,O,@@  ",
"   $o$-:$$$$$>O>;O,<@ ",
"    $oo$----:@$$>;O,< ",
"      $o,,,,@--:$$;O, ",
"          @o,,@@-:$$O ",
"             @,o,@-:$ ",
"               o$o,@- ",
"                 o$o, ",
"                   o$ ",
"                      ",
"                      "};

//! @hideinitializer
static const char* const maxGrip_xpm[]={
"22 22 5 1",
". c None",
"b c #000000",
"c c #808080",
"# c #ff0000",
"a c #ffff00",
"............##abcaaaaa",
"..........##accaaaaaaa",
"..bbbb..##accaabaaaaaa",
"..b##b##accaaaaaaaaaaa",
"..b##bcccaaaaaabaaaaaa",
"..bbbbcaaaaaaaaaaaaaaa",
"...c#caaaaaaaaabaaaaaa",
"....#caaaaaaaaaaaaaaaa",
".....#aaaaaaaaabaaaaaa",
".....#caaaaaaaaaaaaaaa",
"......#aaaaaaaabaaaaaa",
"......#caaaaaaaaaaaaaa",
".......#aaaaaaabaaaaaa",
".......#caaaaaaaaaaaaa",
"........#aaaaabbbaaaaa",
"........#caaaabbbaaaaa",
".........#aaaabbbaaaaa",
".........#caaaaaaaaaaa",
"..........#aaaabaaaaaa",
"..........#caaaaaaaaaa",
"...........#aaabaaaaaa",
"...........#caaaaaaaaa"};

//! @hideinitializer
static const char* const minGrip_xpm[]={
"22 22 5 1",
". c None",
"a c #000000",
"b c #808080",
"# c #ff0000",
"c c #ffff00",
"............##.abccccc",
"..........##.bbccccccc",
"..aaaa..##.bb..acccccc",
"..a##a##.bb....ccccccc",
"..a##abbb......acccccc",
"..aaaab........ccccccc",
"...b#bb........acccccc",
"....#b.........ccccccc",
".....#.........acccccc",
".....#b........ccccccc",
"......#........acccccc",
"......#b.......ccccccc",
".......#.......acccccc",
".......#b......ccccccc",
"........#.....aaaccccc",
"........#b....aaaccccc",
".........#....aaaccccc",
".........#b....ccccccc",
"..........#....acccccc",
"..........#....ccccccc",
"...........#...acccccc",
"...........#b..ccccccc"};

//! @hideinitializer
static const char* const maxDistance_xpm[]={
"22 22 5 1",
". c None",
"b c #000000",
"# c #0000ff",
"c c #58a8ff",
"a c #808080",
"......................",
"............####......",
".......##########.....",
"..##############aa....",
".###########aaaaa.....",
"..#####aaaaaa.........",
"...aaaaa..............",
".........bb...........",
".........bba..........",
"..........aa..........",
"......................",
"......................",
"......................",
"......................",
"......................",
"......................",
"......................",
"......................",
".....cc.cc.cc.cc.c....",
"......aa.aa.aa.aa.a...",
"......................",
"......................"};

//! @hideinitializer
static const char* const minDistance_xpm[]={
"22 22 4 1",
". c None",
"b c #000000",
"# c #0000c0",
"a c #808080",
"......................",
"......................",
"............####......",
".......#####.aaaa.....",
"..#####.aaaaa.........",
"...aaaaa..............",
"......................",
".........bb...........",
".........bba..........",
"..........aa..........",
"......................",
"......................",
"......................",
"......................",
"......................",
"......................",
"......................",
"......................",
".....#############....",
"......aaaaaaaaaaaaa...",
"......................",
"......................"};

//! @hideinitializer
static const char* const maxLength_xpm[]={
"22 22 4 1",
". c None",
"b c #000000",
"# c #0000c0",
"a c #808080",
"......................",
".................###..",
".................#.#a.",
".................###a.",
"..###.............#aa.",
"..#.#a............#a..",
"..###a......bb....#a..",
"...#aa.....bbaa...#a..",
"...#a.....bba.....#a..",
"...#a....bba......#a..",
"...#a...bba.......#a..",
"...#a....bb.......#a..",
"...#a.....bb......#a..",
"...#a......bb.....#a..",
"...#a.......bb....#a..",
"..###........aa...#a..",
"..#.#a............#a..",
"..###a............#a..",
"...aaa...........###..",
".................#.#a.",
".................###a.",
"..................aaa."};

//! @hideinitializer
static const char* const minLength_xpm[]={
"22 22 4 1",
". c None",
"b c #000000",
"# c #0000c0",
"a c #808080",
"......................",
"..###.................",
"..#.#a................",
"..###a................",
"...#aa...........###..",
"...#a............#.#a.",
"...#a.......bb...###a.",
"...#a......bbaa...#aa.",
"...#a.....bba.....#a..",
"...#a....bba......#a..",
"...#a...bba.......#a..",
"...#a....bb.......#a..",
"...#a.....bb......#a..",
"...#a......bb.....#a..",
"...#a.......bb....#a..",
"...#a........aa..###..",
"...#a............#.#a.",
"...#a............###a.",
"..###.............aaa.",
"..#.#a................",
"..###a................",
"...aaa................"};

#define I_ACTION_DRAW         QPixmap(const_cast<const char**>(line_xpm))
#define I_ACTION_TRANSLATE    QPixmap(const_cast<const char**>(translate_xpm))
#define I_ACTION_SCALE        QPixmap(const_cast<const char**>(scale_xpm))
#define I_ACTION_ROTATE       QPixmap(const_cast<const char**>(rotate_xpm))
#define I_ACTION_REGIONBOX    QPixmap(const_cast<const char**>(selectrect_xpm))
#define I_ACTION_REGIONCIRCLE QPixmap(const_cast<const char**>(selectcircle_xpm))
#define I_ACTION_DELETE       QPixmap(const_cast<const char**>(kill_xpm))
#define I_BUTTON_SETTINGS     QPixmap(const_cast<const char**>(configure_xpm))
#define I_BUTTON_WARP         QPixmap(const_cast<const char**>(line_xpm))
#define I_PARAM_MAXGRIP       QPixmap(const_cast<const char**>(maxGrip_xpm))
#define I_PARAM_MINGRIP       QPixmap(const_cast<const char**>(minGrip_xpm))
#define I_PARAM_MAXDISTANCE   QPixmap(const_cast<const char**>(maxDistance_xpm))
#define I_PARAM_MINDISTANCE   QPixmap(const_cast<const char**>(minDistance_xpm))
#define I_PARAM_MAXLENGTH     QPixmap(const_cast<const char**>(maxLength_xpm))
#define I_PARAM_MINLENGTH     QPixmap(const_cast<const char**>(minLength_xpm))
#define I_MISC_DRAWFRAME      QPixmap(const_cast<const char**>(line_xpm))
#define I_MISC_DIFFMODE       QPixmap(const_cast<const char**>(line_xpm))

#endif

