/*
 * Copyleft 2001 Lukas Degener, Ingmar Kanitscheider. All rights granted ;-)
 *----------------------
 * file: src/AlgorithmControl.cpp
 *----------------------
 * This file is part of the ContourWarp Effect based on the GLEffect Framework.
 * In this file you will find the implementation of the AlgorithmControl class
 * Declaration is in AlgorithmControl.h
 */

#include "AlgorithmControl.h"
#include "WarpAlgorithm.h"
#include<qcheckbox.h>

//-----------------------
// class AlgorithmControl
//-----------------------
//*******************************************************
//* For method documentation look in AlgorithmControl.h *
//*******************************************************


AlgorithmControl::AlgorithmControl(QWidget* parent, const char* name, WFlags fl)
                                                   : QWidget( parent, name, fl ){

   //allocate mem for the Algos and mAlgos
   mAlgoCount=1;
   mCurrentAlgo=0;
   mAlgos = new WarpAlgorithm*[mAlgoCount];
   mAlgos[0] = new WarpAlgorithm1();
  
   //Create the LayoutManager for our components
   mLayout=new QVBoxLayout(this);

   //Now create the dropdown list of the algos
   mCombo = new QComboBox(this);
   mCombo->insertItem("Algo1");
   mCombo->insertItem("Algo2 (same as 1)");
   //disable the Dropdown if we have only one algo.
   mCombo->setEnabled(mAlgoCount>1);

   //add the combo to our layout
   mLayout->addWidget(mCombo);
   //connect it to setAlgorithm
   connect(mCombo, SIGNAL(activated(int)), this, SLOT(setAlgorithm(int)) );



   //next, create a QVBox for each algo and put its editor widgets into it
   mBoxes = new QVBox*[mAlgoCount];
   for(int i=0;i<mAlgoCount;i++){
      mBoxes[i]= new QVBox(this);
      mBoxes[i]->setSpacing(0);
      mBoxes[i]->setFrameStyle(QFrame::Panel|QFrame::Sunken);
      for (int j=0;j<mAlgos[i]->getParamCount();j++){
         //get the description for parameter j of Algo i
         paramInfo info;
         mAlgos[i]->getParamInfo(j,info);
         //now create the apropriate Editor widget
         QCheckBox *cb = NULL;
         FloatEditor *fe =NULL;
         switch (info.type)
         {
            // other types are not implemented yet
			case WA_TYPE_FLOAT:
				fe = new FloatEditor(j,mBoxes[i],&info);
				//don't forget to connect!
				connect(fe, SIGNAL(valueChanged(int,float)),
						this, SLOT(setParam(int,float)) );
            break;
         }
      }
      //make sure the boxes are layouted but not visible.
      mLayout->addWidget(mBoxes[i]);
      mBoxes[i]->hide();
   }

	// preselect the first algo
    setAlgorithm(0);	
   
	bool initvalue;
	initvalue = mAlgos[mCurrentAlgo]->getUseConstantEdges();
	// create checkbox in the same QVBox as AlgoControl
	mEAFCheckBox = new QCheckBox ("Bildrand als Kanten", (QWidget *)this->parent());
	mEAFCheckBox->setChecked(initvalue);
	connect(mEAFCheckBox, SIGNAL(toggled(bool)), this, SLOT(setEdgesAsFrame(bool)));
	connect(mEAFCheckBox, SIGNAL(toggled(bool)), this, SIGNAL(frameAsEdgesChanged(bool)));
	QToolTip::add (mEAFCheckBox,"Soll ein Rahmen um das gesamte Bild \nden Skelettkanten hinzugefgt werden?");

}

AlgorithmControl::~AlgorithmControl(){
	// clean up each algorithm
	for (int i=0; i<mAlgoCount; i++)
		delete mAlgos[i];
	// delete algorithm array
	delete mAlgos;
}

WarpAlgorithm *AlgorithmControl::getAlgorithm(){
   return mAlgos[mCurrentAlgo];
}

void AlgorithmControl::setAlgorithm(int index){

   // delete cache
   mAlgos[mCurrentAlgo]->undoPrecalculation();

	//set mCurrentAlgo
   mCurrentAlgo=index;

   //make sure all boxes are invisible except index
   for(int i = 0;i<mAlgoCount;i++){
      if(i==mCurrentAlgo){
         mBoxes[i]->show();
      }
      else{
         mBoxes[i]->hide();
      }
   }
   mLayout->activate();

   emit algoChanged();
   emit warpChanged();
}

void AlgorithmControl::setParam(int index, float value){
   mAlgos[mCurrentAlgo]->setParam(index,&value);
   emit warpChanged();
}

void AlgorithmControl::setParam(int index, int value){
	// yet not implemented
}

void AlgorithmControl::setEdgesAsFrame(bool value)
{
	mAlgos[mCurrentAlgo]->useConstantEdges(value);
	emit warpChanged();
}

void AlgorithmControl::enableControls(bool value)
{
	// This CheckBox isn't Qt child of AlgorithmControl, so
	// we must add an extra enable call
	mEAFCheckBox->setEnabled (value);
	// enable/disable AlgorithmControl
	setEnabled (value);
}
