/*
    Copyright  2001 Christoph Brzozowski - All Rights Reserved.
 
 	This file is part of GL Effects Framework.
 
    GL Effects Framework is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    GL Effects Framework is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GL Effects Framework; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/*! @file QUnclosableDialog.h
 *
 *  @brief
 *	Deklarationen der Klasse \b QUnclosableDialog.
 *   
 *  @author Christoph Brzozowski
 *  
 */

#ifndef wdg_QUnclosableDialogH
#define wdg_QUnclosableDialogH

#include <qdialog.h>

/*!
 * @class QUnclosableDialog
 *
 * @ingroup bsplineWarpClasses
 * 
 * \brief Dialog-Klasse, die nicht geschlossen werden kann 
 * 
 *  Die von \b QDialog abgeleitete Klasse, stellt einen Dialog dar, der nicht
 *  geschlossen werden kann. 
 *  Hierzu wird der \b closeEvent()-Handler berschrieben. Er ruft die Methode
 *  \b ignore() von \b QCloseEvent auf, was zur Folge hat, da das Schlieen
 *  des Fensters abgeblockt wird. 
 */

class QUnclosableDialog : public QDialog
{
public:

	QUnclosableDialog(QWidget* parent=0, const char* name=0, 
			  bool modal=FALSE,
			  WFlags f=0) 
			 : QDialog(parent,name,modal,f)
	{	
	};

protected:
	
	virtual void closeEvent(QCloseEvent* e)	
	{		
		// Close-Event ignorieren
		e->ignore();	
	};

};

#endif

