/*
    Copyright  2001 Christoph Brzozowski - All Rights Reserved.
 
 	This file is part of GL Effects Framework.
 
    GL Effects Framework is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    GL Effects Framework is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GL Effects Framework; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/*! @file CVertexGridKeyFrame.h
 *
 *  @brief
 *	Deklarationen der Klasse \b CVertexGridKeyFrame.
 *   
 *  @author Christoph Brzozowski
 *  
 */

#ifndef cls_CVertexGridKeyFrameH
#define cls_CVertexGridKeyFrameH

#if     _MSC_VER > 1000
#pragma once
#endif

#include <stdlib.h>

/*! 
 *
 * @class CVertexGridKeyFrame
 *
 * @ingroup bsplineWarpClasses
 * 
 * \brief Keyframe-Klasse, welche als Daten ein Vertex-Gitter speichert.
 *
 *  Das von \b CKeyFrame abgeleitete Klassentemplate \b CVertexGridKeyFrame
 *  implementiert ein Keyframe, welches Vertexdaten in einem \b CGrid -Objekt
 *  speichert.  Die Elemente des \b CGrid -Objekts sind hierbei vom Typ \b
 *  CVector.
 *
 *  Der Templateparameter \b N legt die Anzahl der Vektorkomponenten fest,
 *  Der Templateparmaeter \b T deren Typ.
 *
 */
template <int N, class T> class CVertexGridKeyFrame : public CKeyFrame
{

protected:

	//! Speichert einen Zeiger auf das Vertex-Gitter.
	CGrid< CVector<N,T> >* Data; 

public:

	/*! \brief Standardkonstruktor.
	 *
	 *  Der Standardkonstruktor weist dem Keyframe als
	 *  Zeitindex den Parameter \b TimeIndex zu.
	 *  Ferner wird ber \b VertexGrid ein Zeiger auf
	 *  die zugehrigen Vertexdaten bergeben.
	 *
	 *  \note Der festgelegte Zeitindex kann nachtrglich nicht mehr
	 *        direkt gendert werden.
	 *
	 *  \note Der Zeiger auf die Vertexdaten kann nachtrglich nicht mehr
	 *        gendert werden, jedoch die Daten selbst.
	 * 
   */
	CVertexGridKeyFrame(float TimeIndex, CGrid< CVector<N,T> >* VertexGrid) : CKeyFrame(TimeIndex)
	{

		// Referenz  auf Vertex-Grid speicern
		Data = VertexGrid;

	};

	//! Gibt eine Referenz auf das Vertex-Grid zurck, welches das Keyframe speichert.
	CGrid< CVector<N,T> >& VertexGrid()
	{
		return *Data;
	}

	/*! \brief Standarddestruktor
	 *
	 *  Der Destruktor gibt den Speicher wieder frei, der von dem 
	 *  Vertex-Grid belegt wird.
	 *
	 */
	~CVertexGridKeyFrame()
	{
		
		// Vertex-Grid freigeben
		if (Data!=NULL) delete Data;
		Data=NULL;

	};

};

#endif

