/*
    Copyright  2001 Christoph Brzozowski - All Rights Reserved.
 
 	This file is part of GL Effects Framework.
 
    GL Effects Framework is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    GL Effects Framework is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GL Effects Framework; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/*! @file CKeyFrame.h
 *
 *  @brief
 *	Deklarationen der Klasse \b CKeyFrame.
 *   
 *  @author Christoph Brzozowski
 *  
 */

#ifndef cls_CKeyFrameH
#define cls_CKeyFrameH

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <stdlib.h>

// ****************************************************************
//
// Klasse: CKeyFrame
//
// Zweck : Realisiert ein Keyframe ohne Daten. Es ist mglich 
//         einen Zeitindex festzulegen. 
//
// Autor: Christoph Brzozowski
//
// ****************************************************************

/*! 
 *
 * @class CKeyFrame
 *
 * @ingroup bsplineWarpClasses
 * 
 * \brief Basisklasse fr alle abgeleiteten Keyframe-Klassen.
 *
 *  Die Klasse \b CKeyFrame definiert und implementiert eine Schnittstelle, die
 *  allen Keyframe-Objekten gemein ist.  Ein Keyframe ist hierbei ein
 *  Datencontainer, der zustzlich einen Zeitindex besitzt. 
 *
 *  \remarks
 *  Die Klasse \b CFrameList wird als \b friend deklariert, um von dort aus auf
 *  die internen Member von \b CKeyFrame zugreifen zu knnen.
 *
 */
class CKeyFrame
{

protected:
	
	//! Speichert den Zeitindex des Keyframes.
	float TimeIndex; 

public:

	/*! \brief Standardkonstruktor.
	 *
	 *	Der Standardkonstruktor erzeugt ein Keyframe
	 *  und weist diesem als Zeitindex den Parameter
	 *  \b time zu.
	 *
	 *  \note Der Zeitindex kann nachtrglich nicht
	 *        mehr direkt verndert werden.
	 *
	 */
	CKeyFrame(float time)
	{

		// Zeitindex setzen;
		TimeIndex = time;

	};

	//! Gibt den Zeitindex des Keyframes zurck.
	float timeIndex()
	{

		return TimeIndex;

	};
	
	// Frame-List als Friend-Klasse deklarieren, damit
	// von dort aus auf den TimeIndex zugegriffen werden kann.
	friend class CFrameList;

};

#endif
