/*
    Copyright  2001 Christoph Brzozowski - All Rights Reserved.
 
 	This file is part of GL Effects Framework.
 
    GL Effects Framework is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    GL Effects Framework is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GL Effects Framework; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/*! @file CInterpolator.h
 *
 *  @brief
 *	Deklarationen der Klasse \b CInterpolator.
 *   
 *  @author Christoph Brzozowski
 *  
 */

#ifndef cls_CInterpolatorH
#define cls_CInterpolatorH

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <stdlib.h>

/*! 
 * @class CInterpolator
 *
 * @ingroup bsplineWarpClasses
 *
 * \brief Abstrakte Basisklasse fr Interpolationsalgorithmen.
 *
 *  Die abstrakte Basisiklasse \b CInterpolator definiert eine Schnittstelle,
 *  die allen Interpolationsalgorithmen gemein ist.
 *
 */
class CInterpolator
{

public:

	/*! \brief Abstrakte Methode, die in spter abgeleiteten Klassen den
	 * Interpolationsalgorithmus implementiert.
	 *  
	 *  Der Parameter \b TimeIndex steuert die Interpolation.
	 */
	virtual void interpolate(float TimeIndex) = 0;

};

#endif
