/*
    Copyright  2001 Christoph Brzozowski - All Rights Reserved.
 
 	This file is part of GL Effects Framework.
 
    GL Effects Framework is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    GL Effects Framework is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GL Effects Framework; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/*! @file CDeformer.h
 *
 *  @brief
 *	Deklarationen der Klasse \b CDeformer.
 *   
 *  @author Christoph Brzozowski.
 *  
 */

#ifndef cls_CDeformerH
#define cls_CDeformerH

#include <stdlib.h>

/*!
 * @class CDeformer
 *
 * @ingroup bsplineWarpClasses
 * 
 * \brief Abstrakte Basisklasse zur Implementierung von
 * Deformationsalgorithmen.
 *
 *  Die abstrakte Basisklasse \b CDeformer definiert eine Schnittstelle, die
 *  allen Deformationsalgorithmen gemein ist.
 *
 */

class CDeformer
{

public:

	/*! \brief Deformationsmethode.
	 *
	 *  Die abstrakte virtuelle Methode \b deform() dient dazu,
	 *  in nachtrglich abgeleiteten Klassen dort den Deformationsalgorithmus
	 *  zu implementieren.
	 *
	 */
	virtual void deform() = 0;

};

#endif
